/*
 * Decompiled with CFR 0.152.
 */
package ratpack.stream.internal;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class BufferingPublisher<T>
implements Publisher<T> {
    private final AtomicInteger wanted = new AtomicInteger();
    private final ConcurrentLinkedQueue<T> buffer = new ConcurrentLinkedQueue();
    private final AtomicBoolean finished = new AtomicBoolean();
    private final AtomicBoolean draining = new AtomicBoolean();
    private final Publisher<T> publisher;

    public BufferingPublisher(Publisher<T> publisher) {
        this.publisher = publisher;
    }

    public void subscribe(final Subscriber<T> subscriber) {
        this.publisher.subscribe(new Subscriber<T>(){
            public Subscription subscription;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void tryDrain() {
                if (BufferingPublisher.this.draining.compareAndSet(false, true)) {
                    try {
                        int i = BufferingPublisher.this.wanted.get();
                        while (i > 0) {
                            Object item = BufferingPublisher.this.buffer.poll();
                            if (item == null) {
                                if (BufferingPublisher.this.finished.get()) {
                                    subscriber.onComplete();
                                    return;
                                }
                                break;
                            }
                            subscriber.onNext(item);
                            i = BufferingPublisher.this.wanted.decrementAndGet();
                        }
                    }
                    finally {
                        BufferingPublisher.this.draining.set(false);
                    }
                    if (BufferingPublisher.this.buffer.peek() != null && BufferingPublisher.this.wanted.get() > 0) {
                        this.tryDrain();
                    }
                }
            }

            public void onSubscribe(final Subscription subscription) {
                this.subscription = subscription;
                subscription.request(Integer.MAX_VALUE);
                subscriber.onSubscribe(new Subscription(){

                    public void request(int n) {
                        BufferingPublisher.this.wanted.addAndGet(n);
                        this.tryDrain();
                    }

                    public void cancel() {
                        BufferingPublisher.this.finished.compareAndSet(false, true);
                        subscription.cancel();
                    }
                });
            }

            public void onNext(T t) {
                BufferingPublisher.this.buffer.add(t);
                this.tryDrain();
            }

            public void onError(Throwable t) {
                BufferingPublisher.this.buffer.clear();
                BufferingPublisher.this.finished.compareAndSet(false, true);
                subscriber.onError(t);
            }

            public void onComplete() {
                BufferingPublisher.this.finished.compareAndSet(false, true);
                this.tryDrain();
            }
        });
    }
}

