/*
 * Decompiled with CFR 0.152.
 */
package ratpack.stream.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import ratpack.func.Action;

public class GatedPublisher<T>
implements Publisher<T> {
    private final Publisher<T> upstream;
    private final Action<? super Runnable> releaseReceiver;

    public GatedPublisher(Publisher<T> upstream, Action<? super Runnable> releaseReceiver) {
        this.upstream = upstream;
        this.releaseReceiver = releaseReceiver;
    }

    public void subscribe(final Subscriber<T> downstream) {
        final GatedSubscriber<T> gatedSubscriber = new GatedSubscriber<T>(downstream);
        try {
            this.releaseReceiver.execute(new Runnable(){

                @Override
                public void run() {
                    gatedSubscriber.open();
                }
            });
        }
        catch (Throwable e) {
            downstream.onSubscribe(new Subscription(){

                public void request(int n) {
                    downstream.onError(e);
                }

                public void cancel() {
                }
            });
        }
        this.upstream.subscribe(gatedSubscriber);
    }

    private static class GatedSubscriber<T>
    implements Subscriber<T> {
        private Subscription upstreamSubscription;
        private final Subscriber<T> downstream;
        private final AtomicBoolean open = new AtomicBoolean();
        private final AtomicBoolean done = new AtomicBoolean();
        private final AtomicBoolean draining = new AtomicBoolean();
        private final AtomicInteger waiting = new AtomicInteger();

        public GatedSubscriber(Subscriber<T> downstream) {
            this.downstream = downstream;
        }

        private void open() {
            this.open.set(true);
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drain() {
            if (this.draining.compareAndSet(false, true)) {
                try {
                    if (this.open.get()) {
                        int requested = this.waiting.getAndSet(0);
                        this.upstreamSubscription.request(requested);
                    }
                }
                finally {
                    this.draining.set(false);
                }
            }
            if (this.open.get() && this.waiting.get() > 0) {
                this.drain();
            }
        }

        public void onSubscribe(Subscription s) {
            this.upstreamSubscription = s;
            this.downstream.onSubscribe((Subscription)new DownstreamSubscription());
        }

        public void onNext(T t) {
            this.downstream.onNext(t);
        }

        public void onError(Throwable t) {
            this.downstream.onError(t);
        }

        public void onComplete() {
            this.downstream.onComplete();
        }

        private class DownstreamSubscription
        implements Subscription {
            private DownstreamSubscription() {
            }

            public void request(int n) {
                if (GatedSubscriber.this.open.get() && !GatedSubscriber.this.done.get()) {
                    GatedSubscriber.this.upstreamSubscription.request(n);
                } else {
                    GatedSubscriber.this.waiting.addAndGet(n);
                }
            }

            public void cancel() {
                GatedSubscriber.this.upstreamSubscription.cancel();
            }
        }
    }
}

