/*
 * Decompiled with CFR 0.152.
 */
package ratpack.stream.internal;

import java.util.Iterator;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class IterablePublisher<T>
implements Publisher<T> {
    private final Iterable<T> iterable;

    public IterablePublisher(Iterable<T> iterable) {
        this.iterable = iterable;
    }

    public void subscribe(final Subscriber<T> subscriber) {
        subscriber.onSubscribe(new Subscription(){
            Iterator<T> iterator;
            {
                this.iterator = IterablePublisher.this.iterable.iterator();
            }

            public void request(int n) {
                for (int i = 0; i < n && this.iterator.hasNext(); ++i) {
                    Object next;
                    try {
                        next = this.iterator.next();
                    }
                    catch (Exception e) {
                        subscriber.onError((Throwable)e);
                        return;
                    }
                    subscriber.onNext(next);
                }
                if (!this.iterator.hasNext()) {
                    subscriber.onComplete();
                }
            }

            public void cancel() {
            }
        });
    }
}

