/*
 * Decompiled with CFR 0.152.
 */
package ratpack.util.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public class PropertiesUtil {
    public static void extractProperties(String propertyPrefix, Properties properties, Map<? super String, ? super String> destination) {
        for (String propertyName : properties.stringPropertyNames()) {
            if (!propertyName.startsWith(propertyPrefix)) continue;
            destination.put(propertyName.substring(propertyPrefix.length()), properties.getProperty(propertyName));
        }
    }

    public static boolean flatEquals(Properties a, Properties b) {
        return a == b || a != null && PropertiesUtil.flatten(a).equals(PropertiesUtil.flatten(b));
    }

    private static Map<String, String> flatten(Properties properties) {
        LinkedHashMap<String, String> flat = new LinkedHashMap<String, String>();
        for (String key : properties.stringPropertyNames()) {
            flat.put(key, properties.getProperty(key));
        }
        return flat;
    }
}

