/*
 * Decompiled with CFR 0.152.
 */
package ratpack.websocket.internal;

import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import ratpack.websocket.WebSocket;

public class WebsocketBroadcastSubscriber
implements Subscriber<String>,
AutoCloseable {
    private final WebSocket webSocket;
    private Subscription subscription;
    protected boolean terminated;

    public WebsocketBroadcastSubscriber(WebSocket webSocket) {
        this.webSocket = webSocket;
    }

    @Override
    public void close() {
        this.terminated = true;
        if (this.subscription != null) {
            this.subscription.cancel();
        }
    }

    public void onSubscribe(Subscription s) {
        if (this.subscription == null) {
            this.subscription = s;
            this.subscription.request(Integer.MAX_VALUE);
        } else {
            this.subscription.cancel();
        }
    }

    public void onNext(String s) {
        if (!this.terminated) {
            this.webSocket.send(s);
        }
    }

    public void onError(Throwable t) {
        if (!this.terminated) {
            this.webSocket.close(1011, t.getMessage());
        }
    }

    public void onComplete() {
        if (!this.terminated) {
            this.webSocket.close();
        }
    }
}

