/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.internal;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import ratpack.exec.Fulfiller;
import ratpack.exec.Promise;
import ratpack.exec.Result;
import ratpack.exec.SuccessPromise;
import ratpack.exec.internal.DefaultResult;
import ratpack.exec.internal.DefaultSuccessPromise;
import ratpack.exec.internal.ExecutionBacking;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.func.NoArgAction;
import ratpack.func.Predicate;

public class CachingPromise<T>
implements Promise<T> {
    private final Action<? super Fulfiller<T>> action;
    private final Supplier<ExecutionBacking> executionSupplier;
    private final Action<? super Throwable> errorHandler;
    private final AtomicBoolean fired = new AtomicBoolean();
    private final ConcurrentLinkedQueue<Fulfiller<T>> waiting = new ConcurrentLinkedQueue();
    private final AtomicBoolean draining = new AtomicBoolean();
    private final AtomicReference<Result<T>> result = new AtomicReference();

    public CachingPromise(Action<? super Fulfiller<T>> action, Supplier<ExecutionBacking> executionSupplier, Action<? super Throwable> errorHandler) {
        this.action = action;
        this.executionSupplier = executionSupplier;
        this.errorHandler = errorHandler;
    }

    @Override
    public SuccessPromise<T> onError(Action<? super Throwable> errorHandler) {
        return new DefaultSuccessPromise(this.executionSupplier, new Fulfillment(), errorHandler);
    }

    @Override
    public void then(Action<? super T> then) {
        this.newPromise().then(then);
    }

    private void tryDrain() {
        if (this.draining.compareAndSet(false, true)) {
            try {
                Result<T> result = this.result.get();
                Fulfiller<T> poll = this.waiting.poll();
                while (poll != null) {
                    this.fulfill(result, poll);
                    poll = this.waiting.poll();
                }
            }
            finally {
                this.draining.set(false);
            }
        }
        if (!this.waiting.isEmpty()) {
            this.tryDrain();
        }
    }

    private DefaultSuccessPromise<T> newPromise() {
        return new DefaultSuccessPromise(this.executionSupplier, new Fulfillment(), this.errorHandler);
    }

    @Override
    public <O> Promise<O> map(Function<? super T, ? extends O> transformer) {
        return this.newPromise().map(transformer);
    }

    @Override
    public <O> Promise<O> blockingMap(Function<? super T, ? extends O> transformer) {
        return this.newPromise().blockingMap(transformer);
    }

    @Override
    public <O> Promise<O> flatMap(Function<? super T, ? extends Promise<O>> transformer) {
        return this.newPromise().flatMap(transformer);
    }

    @Override
    public Promise<T> route(Predicate<? super T> predicate, Action<? super T> action) {
        return this.newPromise().route(predicate, action);
    }

    @Override
    public Promise<T> onNull(NoArgAction action) {
        return this.newPromise().onNull(action);
    }

    @Override
    public Promise<T> cache() {
        return this;
    }

    void fulfill(Result<T> result, Fulfiller<? super T> fulfiller) {
        if (result.isFailure()) {
            fulfiller.error(result.getFailure());
        } else {
            fulfiller.success(result.getValue());
        }
    }

    private class Fulfillment
    implements Action<Fulfiller<T>> {
        private Fulfillment() {
        }

        @Override
        public void execute(Fulfiller<T> fulfiller) throws Exception {
            Result resultValue;
            if (CachingPromise.this.fired.compareAndSet(false, true)) {
                try {
                    CachingPromise.this.action.execute(new Fulfiller<T>(){

                        @Override
                        public void error(Throwable throwable) {
                            CachingPromise.this.result.set(DefaultResult.failure(throwable));
                            CachingPromise.this.tryDrain();
                        }

                        @Override
                        public void success(T value) {
                            CachingPromise.this.result.set(DefaultResult.success(value));
                            CachingPromise.this.tryDrain();
                        }
                    });
                }
                catch (Throwable throwable) {
                    CachingPromise.this.result.set(DefaultResult.failure(throwable));
                    CachingPromise.this.tryDrain();
                }
            }
            if ((resultValue = (Result)CachingPromise.this.result.get()) == null) {
                CachingPromise.this.waiting.add(fulfiller);
                if (CachingPromise.this.result.get() != null) {
                    CachingPromise.this.tryDrain();
                }
            } else {
                CachingPromise.this.fulfill(resultValue, fulfiller);
            }
        }
    }
}

