/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.internal;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import ratpack.exec.ExecControl;
import ratpack.exec.ExecController;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.Execution;
import ratpack.exec.ExecutionException;
import ratpack.exec.Fulfiller;
import ratpack.exec.Promise;
import ratpack.exec.internal.DefaultPromise;
import ratpack.exec.internal.ExecutionBacking;
import ratpack.func.Action;

public class DefaultExecControl
implements ExecControl {
    private final ExecController execController;
    private final ThreadLocal<ExecutionBacking> threadBinding = new ThreadLocal();

    public DefaultExecControl(ExecController execController) {
        this.execController = execController;
    }

    private ExecutionBacking getBacking() {
        ExecutionBacking executionBacking = this.threadBinding.get();
        if (executionBacking == null) {
            throw new ExecutionException("Current thread has no bound execution");
        }
        return executionBacking;
    }

    @Override
    public Execution getExecution() {
        return this.getBacking().getExecution();
    }

    @Override
    public ExecController getController() {
        return this.execController;
    }

    @Override
    public void addInterceptor(ExecInterceptor execInterceptor, Action<? super Execution> continuation) throws Exception {
        ExecutionBacking backing = this.getBacking();
        backing.getInterceptors().add(execInterceptor);
        backing.intercept(ExecInterceptor.ExecType.COMPUTE, Collections.singletonList(execInterceptor), continuation);
    }

    @Override
    public <T> Promise<T> blocking(Callable<T> blockingOperation) {
        ExecutionBacking backing = this.getBacking();
        ExecController controller = backing.getController();
        return this.promise(fulfiller -> {
            ListenableFuture future = controller.getBlockingExecutor().submit(new BlockingOperation(backing, blockingOperation));
            Futures.addCallback((ListenableFuture)future, new ComputeResume(fulfiller), (Executor)controller.getExecutor());
        });
    }

    @Override
    public <T> Promise<T> promise(Action<? super Fulfiller<T>> action) {
        return new DefaultPromise(this::getBacking, action);
    }

    @Override
    public void fork(Action<? super Execution> action) {
        this.fork(action, Action.throwException(), Action.noop());
    }

    @Override
    public void fork(Action<? super Execution> action, Action<? super Throwable> onError) {
        this.fork(action, onError, Action.noop());
    }

    @Override
    public void fork(Action<? super Execution> action, Action<? super Throwable> onError, Action<? super Execution> onComplete) {
        if (this.execController.isManagedThread() && this.threadBinding.get() == null) {
            new ExecutionBacking(this.execController, this.threadBinding, action, onError, onComplete);
        } else {
            this.execController.getExecutor().submit(() -> new ExecutionBacking(this.execController, this.threadBinding, action, onError, onComplete));
        }
    }

    @Override
    public <T> void stream(Publisher<T> publisher, Subscriber<? super T> subscriber) {
        ExecutionBacking executionBacking = this.getBacking();
        this.promise(fulfiller -> publisher.subscribe(new Subscriber<T>((Fulfiller)fulfiller, executionBacking, subscriber){
            final /* synthetic */ Fulfiller val$fulfiller;
            final /* synthetic */ ExecutionBacking val$cap$1;
            final /* synthetic */ Subscriber val$cap$2;
            {
                this.val$fulfiller = fulfiller;
                this.val$cap$1 = executionBacking;
                this.val$cap$2 = subscriber;
            }

            public void onSubscribe(Subscription subscription) {
                this.val$fulfiller.success(subscription);
            }

            public void onNext(T element) {
                this.val$cap$1.streamExecution(execution -> this.val$cap$2.onNext(element));
            }

            public void onComplete() {
                this.val$cap$1.completeStreamExecution(execution -> this.val$cap$2.onComplete());
            }

            public void onError(Throwable cause) {
                this.val$cap$1.completeStreamExecution(execution -> this.val$cap$2.onError(cause));
            }
        })).then(subscription -> executionBacking.streamExecution(execution -> subscriber.onSubscribe(subscription)));
    }

    class BlockingOperation<T>
    implements Callable<T> {
        private final ExecutionBacking backing;
        private final Callable<T> blockingOperation;
        private T result;
        private Exception exception;

        BlockingOperation(ExecutionBacking backing, Callable<T> blockingOperation) {
            this.backing = backing;
            this.blockingOperation = blockingOperation;
        }

        @Override
        public T call() throws Exception {
            this.backing.intercept(ExecInterceptor.ExecType.BLOCKING, this.backing.getInterceptors(), execution -> {
                try {
                    this.result = this.blockingOperation.call();
                }
                catch (Exception e) {
                    this.exception = e;
                }
            });
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }
    }

    private static class ComputeResume<T>
    implements FutureCallback<T> {
        private final Fulfiller<? super T> fulfiller;

        public ComputeResume(Fulfiller<? super T> fulfiller) {
            this.fulfiller = fulfiller;
        }

        public void onSuccess(T result) {
            this.fulfiller.success(result);
        }

        public void onFailure(Throwable t) {
            this.fulfiller.error(t);
        }
    }
}

