/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.internal;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import ratpack.exec.ExecControl;
import ratpack.exec.ExecController;
import ratpack.exec.internal.DefaultExecControl;
import ratpack.exec.internal.ExecControllerThreadBinding;

public class DefaultExecController
implements ExecController {
    private final ListeningScheduledExecutorService computeExecutor;
    private final ListeningExecutorService blockingExecutor;
    private final EventLoopGroup eventLoopGroup;
    private final ExecControl control;
    private final int numThreads;

    public DefaultExecController(int numThreads) {
        this.numThreads = numThreads;
        this.eventLoopGroup = new NioEventLoopGroup(numThreads, (ThreadFactory)((Object)new ExecControllerBindingThreadFactory("ratpack-compute", 10)));
        this.computeExecutor = MoreExecutors.listeningDecorator((ScheduledExecutorService)this.eventLoopGroup);
        this.blockingExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool((ThreadFactory)((Object)new ExecControllerBindingThreadFactory("ratpack-blocking", 5))));
        this.control = new DefaultExecControl(this);
    }

    @Override
    public void close() {
        this.eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        this.blockingExecutor.shutdown();
    }

    @Override
    public ListeningScheduledExecutorService getExecutor() {
        return this.computeExecutor;
    }

    @Override
    public ListeningExecutorService getBlockingExecutor() {
        return this.blockingExecutor;
    }

    @Override
    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    @Override
    public ExecControl getControl() {
        return this.control;
    }

    @Override
    public boolean isManagedThread() {
        return ExecControllerThreadBinding.get().map(c -> c == this).orElse(false);
    }

    @Override
    public int getNumThreads() {
        return this.numThreads;
    }

    private class ExecControllerBindingThreadFactory
    extends DefaultThreadFactory {
        public ExecControllerBindingThreadFactory(String name, int priority) {
            super(name, priority);
        }

        public Thread newThread(Runnable r) {
            return super.newThread(() -> {
                ExecControllerThreadBinding.set(DefaultExecController.this);
                r.run();
            });
        }
    }
}

