/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import ratpack.exec.Fulfiller;
import ratpack.exec.Promise;
import ratpack.exec.SuccessPromise;
import ratpack.exec.internal.DefaultSuccessPromise;
import ratpack.exec.internal.ExecutionBacking;
import ratpack.exec.internal.MultiplePromiseSubscriptionException;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.func.NoArgAction;
import ratpack.func.Predicate;

public class DefaultPromise<T>
implements Promise<T> {
    private final Action<? super Fulfiller<T>> fulfillment;
    private final Supplier<ExecutionBacking> executionProvider;
    private final AtomicBoolean fired = new AtomicBoolean();

    public DefaultPromise(Supplier<ExecutionBacking> executionProvider, Action<? super Fulfiller<T>> fulfillment) {
        this.executionProvider = executionProvider;
        this.fulfillment = fulfillment;
    }

    @Override
    public SuccessPromise<T> onError(Action<? super Throwable> errorHandler) {
        if (this.fired.compareAndSet(false, true)) {
            return new DefaultSuccessPromise(this.executionProvider, this.fulfillment, errorHandler);
        }
        throw new MultiplePromiseSubscriptionException();
    }

    @Override
    public void then(Action<? super T> then) {
        this.propagatingSuccessPromise().then(then);
    }

    private SuccessPromise<T> propagatingSuccessPromise() {
        return this.onError(Action.throwException());
    }

    @Override
    public <O> Promise<O> map(Function<? super T, ? extends O> transformer) {
        return this.propagatingSuccessPromise().map(transformer);
    }

    @Override
    public <O> Promise<O> blockingMap(Function<? super T, ? extends O> transformer) {
        return this.propagatingSuccessPromise().blockingMap(transformer);
    }

    @Override
    public <O> Promise<O> flatMap(Function<? super T, ? extends Promise<O>> transformer) {
        return this.propagatingSuccessPromise().flatMap(transformer);
    }

    @Override
    public Promise<T> route(Predicate<? super T> predicate, Action<? super T> action) {
        return this.propagatingSuccessPromise().route(predicate, action);
    }

    @Override
    public Promise<T> onNull(NoArgAction action) {
        return this.propagatingSuccessPromise().onNull(action);
    }

    @Override
    public Promise<T> cache() {
        return this.propagatingSuccessPromise().cache();
    }
}

