/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.internal;

import ratpack.exec.Result;
import ratpack.util.ExceptionUtils;

public class DefaultResult<T>
implements Result<T> {
    private final Throwable failure;
    private final T value;

    public static <T> Result<T> success(T value) {
        return new DefaultResult<T>(value);
    }

    public static <T> Result<T> failure(Throwable failure) {
        return new DefaultResult<T>(failure);
    }

    private DefaultResult(Throwable failure) {
        this.failure = failure;
        this.value = null;
    }

    private DefaultResult(T value) {
        this.value = value;
        this.failure = null;
    }

    @Override
    public Throwable getFailure() {
        return this.failure;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public boolean isSuccess() {
        return this.failure == null;
    }

    @Override
    public boolean isFailure() {
        return this.failure != null;
    }

    @Override
    public T getValueOrThrow() throws Exception {
        if (this.isFailure()) {
            throw ExceptionUtils.toException(this.failure);
        }
        return this.value;
    }
}

