/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.internal;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.exec.ExecutionException;
import ratpack.exec.Fulfiller;
import ratpack.exec.OverlappingExecutionException;
import ratpack.exec.Promise;
import ratpack.exec.SuccessPromise;
import ratpack.exec.internal.CachingPromise;
import ratpack.exec.internal.DefaultPromise;
import ratpack.exec.internal.ExecutionBacking;
import ratpack.exec.internal.MultiplePromiseSubscriptionException;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.func.NoArgAction;
import ratpack.func.Predicate;
import ratpack.util.internal.InternalRatpackError;

public class DefaultSuccessPromise<T>
implements SuccessPromise<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSuccessPromise.class);
    private final Supplier<ExecutionBacking> executionSupplier;
    private final Action<? super Fulfiller<T>> action;
    private final Action<? super Throwable> errorHandler;
    private final AtomicBoolean fired = new AtomicBoolean();

    public DefaultSuccessPromise(Supplier<ExecutionBacking> executionSupplier, Action<? super Fulfiller<T>> action, Action<? super Throwable> errorHandler) {
        this.executionSupplier = executionSupplier;
        this.action = action;
        this.errorHandler = errorHandler;
    }

    @Override
    public void then(Action<? super T> then) {
        if (this.fired.compareAndSet(false, true)) {
            ExecutionBacking executionBacking = this.executionSupplier.get();
            try {
                executionBacking.continueVia(() -> this.doThen(new UserActionFulfiller(executionBacking, then)));
            }
            catch (ExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InternalRatpackError("failed to add promise resume action", e);
            }
        } else {
            throw new MultiplePromiseSubscriptionException();
        }
    }

    private void doThen(final Fulfiller<? super T> outer) {
        final ExecutionBacking executionBacking = this.executionSupplier.get();
        final AtomicBoolean fulfilled = new AtomicBoolean();
        try {
            this.action.execute(new Fulfiller<T>(){

                @Override
                public void error(Throwable throwable) {
                    if (!fulfilled.compareAndSet(false, true)) {
                        LOGGER.error("", (Throwable)new OverlappingExecutionException("promise already fulfilled", throwable));
                        return;
                    }
                    executionBacking.join(execution -> outer.error(throwable));
                }

                @Override
                public void success(T value) {
                    if (!fulfilled.compareAndSet(false, true)) {
                        LOGGER.error("", (Throwable)new OverlappingExecutionException("promise already fulfilled"));
                        return;
                    }
                    executionBacking.join(execution -> outer.success(value));
                }
            });
        }
        catch (Throwable throwable) {
            if (!fulfilled.compareAndSet(false, true)) {
                LOGGER.error("", (Throwable)new OverlappingExecutionException("exception thrown after promise was fulfilled", throwable));
            }
            executionBacking.join(Action.throwException(throwable));
        }
    }

    @Override
    public <O> DefaultPromise<O> map(Function<? super T, ? extends O> transformer) {
        if (this.fired.compareAndSet(false, true)) {
            return new DefaultPromise(this.executionSupplier, downstream -> this.doThen(new Transform<O, O>((Fulfiller)downstream, transformer){

                @Override
                protected void onSuccess(O transformed) {
                    this.downstream.success(transformed);
                }
            }));
        }
        throw new MultiplePromiseSubscriptionException();
    }

    @Override
    public <O> Promise<O> flatMap(Function<? super T, ? extends Promise<O>> transformer) {
        if (this.fired.compareAndSet(false, true)) {
            return new DefaultPromise(this.executionSupplier, downstream -> this.doThen(new Transform<Promise<O>, O>((Fulfiller)downstream, transformer){

                @Override
                protected void onSuccess(Promise<O> transformed) {
                    transformed.onError(this.downstream::error).then(this.downstream::success);
                }
            }));
        }
        throw new MultiplePromiseSubscriptionException();
    }

    @Override
    public Promise<T> route(final Predicate<? super T> predicate, final Action<? super T> action) {
        if (this.fired.compareAndSet(false, true)) {
            return new DefaultPromise(this.executionSupplier, new Action<Fulfiller<T>>(){

                @Override
                public void execute(Fulfiller<T> downstream) throws Exception {
                    DefaultSuccessPromise.this.doThen(new Step<T>(downstream){

                        @Override
                        public void success(T value) {
                            boolean apply;
                            try {
                                apply = predicate.apply(value);
                            }
                            catch (Throwable e) {
                                this.error(e);
                                return;
                            }
                            if (apply) {
                                try {
                                    action.execute(value);
                                }
                                catch (Throwable e) {
                                    this.error(e);
                                }
                            } else {
                                this.downstream.success(value);
                            }
                        }
                    });
                }
            });
        }
        throw new MultiplePromiseSubscriptionException();
    }

    @Override
    public Promise<T> onNull(NoArgAction onNull) {
        return this.route(Objects::isNull, Action.ignoreArg(onNull));
    }

    @Override
    public <O> Promise<O> blockingMap(final Function<? super T, ? extends O> transformer) {
        return this.flatMap(new Function<T, Promise<O>>(){

            @Override
            public Promise<O> apply(T t) throws Exception {
                return ((ExecutionBacking)DefaultSuccessPromise.this.executionSupplier.get()).getExecution().getControl().blocking(() -> transformer.apply(t));
            }
        });
    }

    @Override
    public Promise<T> cache() {
        if (this.fired.compareAndSet(false, true)) {
            return new CachingPromise(this.action, this.executionSupplier, this.errorHandler);
        }
        throw new MultiplePromiseSubscriptionException();
    }

    private class UserActionFulfiller
    implements Fulfiller<T> {
        private final ExecutionBacking executionBacking;
        private final Action<? super T> then;

        public UserActionFulfiller(ExecutionBacking executionBacking, Action<? super T> then) {
            this.executionBacking = executionBacking;
            this.then = then;
        }

        @Override
        public void error(Throwable throwable) {
            try {
                DefaultSuccessPromise.this.errorHandler.execute(throwable);
            }
            catch (Throwable errorHandlerThrown) {
                this.executionBacking.join(Action.throwException(errorHandlerThrown));
            }
        }

        @Override
        public void success(T value) {
            try {
                this.then.execute(value);
            }
            catch (Throwable throwable) {
                this.executionBacking.join(Action.throwException(throwable));
            }
        }
    }

    private abstract class Transform<I, O>
    extends Step<O> {
        private final Function<? super T, ? extends I> function;

        public Transform(Fulfiller<O> downstream, Function<? super T, ? extends I> function) {
            super(downstream);
            this.function = function;
        }

        @Override
        public void success(T value) {
            I transformed;
            try {
                transformed = this.function.apply(value);
            }
            catch (Throwable e) {
                this.downstream.error(e);
                return;
            }
            this.onSuccess(transformed);
        }

        protected abstract void onSuccess(I var1);
    }

    private abstract class Step<O>
    implements Fulfiller<T> {
        protected final Fulfiller<O> downstream;

        public Step(Fulfiller<O> downstream) {
            this.downstream = downstream;
        }

        @Override
        public void error(Throwable throwable) {
            try {
                DefaultSuccessPromise.this.errorHandler.execute(throwable);
            }
            catch (Throwable e) {
                this.downstream.error(e);
            }
        }
    }
}

