/*
 * Decompiled with CFR 0.152.
 */
package ratpack.file.internal;

import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.ExecutionException;
import ratpack.func.Pair;
import ratpack.util.ExceptionUtils;

public class ShouldCompressPredicate
implements Predicate<Pair<Long, String>> {
    private final long compressionMinSize;
    private final ImmutableSet<String> compressionMimeTypeWhiteList;
    private final ImmutableSet<String> compressionMimeTypeBlackList;
    private final LoadingCache<String, Boolean> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Boolean>(){

        public Boolean load(String key) throws Exception {
            for (String s : ShouldCompressPredicate.this.compressionMimeTypeWhiteList) {
                if (!key.startsWith(s)) continue;
                return true;
            }
            for (String s : ShouldCompressPredicate.this.compressionMimeTypeBlackList) {
                if (!key.startsWith(s)) continue;
                return false;
            }
            return true;
        }
    });

    public ShouldCompressPredicate(long compressionMinSize, ImmutableSet<String> compressionMimeTypeWhiteList, ImmutableSet<String> compressionMimeTypeBlackList) {
        this.compressionMinSize = compressionMinSize;
        this.compressionMimeTypeWhiteList = compressionMimeTypeWhiteList;
        this.compressionMimeTypeBlackList = compressionMimeTypeBlackList;
    }

    public boolean apply(Pair<Long, String> fileDetails) {
        if ((Long)fileDetails.left < this.compressionMinSize) {
            return false;
        }
        try {
            return (Boolean)this.cache.get(fileDetails.right);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw ExceptionUtils.uncheck(ExceptionUtils.toException(e.getCause()));
        }
    }
}

