/*
 * Decompiled with CFR 0.152.
 */
package ratpack.func;

import java.util.function.Consumer;
import ratpack.func.NoArgAction;
import ratpack.util.ExceptionUtils;

@FunctionalInterface
public interface Action<T> {
    public static Action<Object> noop() {
        return thing -> {};
    }

    public static <T> Action<? super T> noopIfNull(Action<T> action) {
        if (action == null) {
            return Action.noop();
        }
        return action;
    }

    @SafeVarargs
    public static <T> Action<T> join(final Action<? super T> ... actions) {
        return new Action<T>(){

            @Override
            public void execute(T thing) throws Exception {
                for (Action action : actions) {
                    action.execute(thing);
                }
            }
        };
    }

    public static Action<Throwable> throwException() {
        return throwable -> {
            throw ExceptionUtils.toException(throwable);
        };
    }

    public static <T> Action<T> throwException(Throwable throwable) {
        return t -> {
            throw ExceptionUtils.toException(throwable);
        };
    }

    public static <T> Action<T> ignoreArg(NoArgAction noArgAction) {
        return t -> noArgAction.execute();
    }

    public static <T> T with(T t, Action<? super T> action) throws Exception {
        action.execute(t);
        return t;
    }

    public void execute(T var1) throws Exception;

    default public Consumer<T> toConsumer() {
        return t -> {
            try {
                this.execute(t);
            }
            catch (Exception e) {
                throw ExceptionUtils.uncheck(e);
            }
        };
    }

    public static <T> Action<T> from(Consumer<T> consumer) {
        return consumer::accept;
    }
}

