/*
 * Decompiled with CFR 0.152.
 */
package ratpack.func;

import ratpack.func.Function;

public final class Pair<L, R> {
    public final L left;
    public final R right;

    private Pair(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public L getLeft() {
        return this.left;
    }

    public R getRight() {
        return this.right;
    }

    public static <L, R> Pair<L, R> of(L left, R right) {
        return new Pair<L, R>(left, right);
    }

    public static <L, R> Pair<L, R> pair(L left, R right) {
        return Pair.of(left, right);
    }

    public <T> Pair<T, Pair<L, R>> pushLeft(T t) {
        return Pair.of(t, this);
    }

    public <T> Pair<Pair<L, R>, T> pushRight(T t) {
        return Pair.of(this, t);
    }

    public <T> Pair<Pair<T, L>, R> nestLeft(T t) {
        return Pair.of(Pair.of(t, this.left), this.right);
    }

    public <T> Pair<L, Pair<T, R>> nestRight(T t) {
        return Pair.of(this.left, Pair.of(t, this.right));
    }

    public <T> Pair<T, R> mapLeft(Function<? super L, ? extends T> function) throws Exception {
        T t = function.apply(this.left);
        return Pair.of(t, this.right);
    }

    public <T> Pair<L, T> mapRight(Function<? super R, ? extends T> function) throws Exception {
        T t = function.apply(this.right);
        return Pair.of(this.left, t);
    }

    public <T> T map(Function<? super Pair<L, R>, ? extends T> function) throws Exception {
        return function.apply(this);
    }

    public static <L, P extends Pair<L, ?>> Function<P, L> unpackLeft() {
        return pair -> pair.left;
    }

    public static <R, P extends Pair<?, R>> Function<P, R> unpackRight() {
        return pair -> pair.right;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        return !(this.left == null ? pair.left != null : !this.left.equals(pair.left)) && !(this.right == null ? pair.right != null : !this.right.equals(pair.right));
    }

    public int hashCode() {
        int result = this.left != null ? this.left.hashCode() : 0;
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Pair[" + this.left + "," + this.right + ']';
    }
}

