/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client.internal;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import ratpack.exec.ExecControl;
import ratpack.exec.ExecController;
import ratpack.exec.Execution;
import ratpack.exec.Fulfiller;
import ratpack.exec.Promise;
import ratpack.func.Action;
import ratpack.http.HttpUrlSpec;
import ratpack.http.MutableHeaders;
import ratpack.http.Status;
import ratpack.http.client.HttpClient;
import ratpack.http.client.ReceivedResponse;
import ratpack.http.client.RequestSpec;
import ratpack.http.client.internal.DefaultReceivedResponse;
import ratpack.http.client.internal.RequestSpecBacking;
import ratpack.http.internal.ByteBufBackedTypedData;
import ratpack.http.internal.DefaultMediaType;
import ratpack.http.internal.DefaultStatus;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.http.internal.NettyHeadersBackedHeaders;
import ratpack.http.internal.NettyHeadersBackedMutableHeaders;
import ratpack.util.ExceptionUtils;

public class DefaultHttpClient
implements HttpClient {
    private final ExecController execController;
    private final ByteBufAllocator byteBufAllocator;
    private final int maxContentLengthBytes;

    public DefaultHttpClient(ExecController execController, ByteBufAllocator byteBufAllocator, int maxContentLengthBytes) {
        this.execController = execController;
        this.byteBufAllocator = byteBufAllocator;
        this.maxContentLengthBytes = maxContentLengthBytes;
    }

    @Override
    public Promise<ReceivedResponse> get(Action<? super RequestSpec> requestConfigurer) {
        return this.request(requestConfigurer);
    }

    @Override
    public Promise<ReceivedResponse> post(Action<? super RequestSpec> action) {
        return this.request(Action.join(new Post(), action));
    }

    @Override
    public Promise<ReceivedResponse> request(Action<? super RequestSpec> requestConfigurer) {
        ExecControl execControl = this.execController.getControl();
        Execution execution = execControl.getExecution();
        EventLoopGroup eventLoopGroup = this.execController.getEventLoopGroup();
        try {
            RequestAction requestAction = new RequestAction(requestConfigurer, execution, eventLoopGroup, this.byteBufAllocator, this.maxContentLengthBytes);
            return this.execController.getControl().promise(requestAction);
        }
        catch (Exception e) {
            throw ExceptionUtils.uncheck(e);
        }
    }

    private static ByteBuf initBufferReleaseOnExecutionClose(final ByteBuf responseBuffer, Execution execution) {
        execution.onCleanup(new AutoCloseable(){

            @Override
            public void close() {
                responseBuffer.release();
            }
        });
        return responseBuffer.retain();
    }

    private static String getFullPath(URI uri) {
        StringBuilder sb = new StringBuilder(uri.getRawPath());
        String query = uri.getRawQuery();
        if (query != null) {
            sb.append("?").append(query);
        }
        return sb.toString();
    }

    private static class RedirectConfigurer
    implements Action<RequestSpec> {
        private URI url;
        private int maxRedirect;

        RedirectConfigurer(URI url, int maxRedirect) {
            this.url = url;
            this.maxRedirect = maxRedirect;
        }

        @Override
        public void execute(RequestSpec requestSpec) throws Exception {
            requestSpec.url((Action<? super HttpUrlSpec>)new Action<HttpUrlSpec>(){

                @Override
                public void execute(HttpUrlSpec httpUrlSpec) throws Exception {
                    httpUrlSpec.set(url);
                }
            });
            requestSpec.redirects(this.maxRedirect);
        }
    }

    private static class RequestAction
    implements Action<Fulfiller<ReceivedResponse>> {
        final Execution execution;
        final EventLoopGroup eventLoopGroup;
        final Action<? super RequestSpec> requestConfigurer;
        final boolean finalUseSsl;
        final String host;
        final int port;
        final MutableHeaders headers;
        final RequestSpecBacking requestSpecBacking;
        final URI uri;
        private final ByteBufAllocator byteBufAllocator;
        private final int maxContentLengthBytes;

        public RequestAction(Action<? super RequestSpec> requestConfigurer, Execution execution, EventLoopGroup eventLoopGroup, ByteBufAllocator byteBufAllocator, int maxContentLengthBytes) {
            this.execution = execution;
            this.eventLoopGroup = eventLoopGroup;
            this.requestConfigurer = requestConfigurer;
            this.byteBufAllocator = byteBufAllocator;
            this.maxContentLengthBytes = maxContentLengthBytes;
            this.headers = new NettyHeadersBackedMutableHeaders((HttpHeaders)new DefaultHttpHeaders());
            this.requestSpecBacking = new RequestSpecBacking(this.headers, byteBufAllocator);
            try {
                requestConfigurer.execute(this.requestSpecBacking.asSpec());
            }
            catch (Exception e) {
                throw ExceptionUtils.uncheck(e);
            }
            this.uri = this.requestSpecBacking.getUrl();
            String scheme = this.uri.getScheme();
            boolean useSsl = false;
            if (scheme.equals("https")) {
                useSsl = true;
            } else if (!scheme.equals("http")) {
                throw new IllegalArgumentException(String.format("URL '%s' is not a http url", this.uri.toString()));
            }
            this.finalUseSsl = useSsl;
            this.host = this.uri.getHost();
            this.port = this.uri.getPort() < 0 ? (useSsl ? 443 : 80) : this.uri.getPort();
        }

        @Override
        public void execute(final Fulfiller<ReceivedResponse> fulfiller) throws Exception {
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)b.group(this.eventLoopGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    if (finalUseSsl) {
                        SSLEngine engine = SSLContext.getDefault().createSSLEngine();
                        engine.setUseClientMode(true);
                        p.addLast("ssl", (ChannelHandler)new SslHandler(engine));
                    }
                    p.addLast("codec", (ChannelHandler)new HttpClientCodec());
                    p.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(maxContentLengthBytes));
                    p.addLast("handler", (ChannelHandler)new SimpleChannelInboundHandler<HttpObject>(){

                        public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
                            if (msg instanceof FullHttpResponse) {
                                FullHttpResponse response = (FullHttpResponse)msg;
                                NettyHeadersBackedHeaders headers = new NettyHeadersBackedHeaders(response.headers());
                                String contentType = headers.get(HttpHeaderConstants.CONTENT_TYPE.toString());
                                ByteBuf responseBuffer = DefaultHttpClient.initBufferReleaseOnExecutionClose(response.content(), execution);
                                ByteBufBackedTypedData typedData = new ByteBufBackedTypedData(responseBuffer, DefaultMediaType.get(contentType));
                                DefaultStatus status = new DefaultStatus(response.getStatus());
                                int maxRedirects = requestSpecBacking.getMaxRedirects();
                                String locationValue = headers.get("Location");
                                URI locationUrl = null;
                                if (locationValue != null) {
                                    locationUrl = new URI(locationValue);
                                }
                                if (RequestAction.isRedirect(status) && maxRedirects > 0 && locationUrl != null) {
                                    Action redirectRequestConfg = Action.join(requestConfigurer, new RedirectConfigurer(locationUrl, maxRedirects - 1));
                                    RequestAction requestAction = new RequestAction(redirectRequestConfg, execution, eventLoopGroup, byteBufAllocator, maxContentLengthBytes);
                                    requestAction.execute(fulfiller);
                                } else {
                                    fulfiller.success(new DefaultReceivedResponse(status, headers, typedData));
                                }
                            }
                        }

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                            ctx.close();
                            fulfiller.error(cause);
                        }
                    });
                }
            });
            b.connect(this.host, this.port).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        String fullPath = DefaultHttpClient.getFullPath(uri);
                        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)requestSpecBacking.getMethod()), fullPath, requestSpecBacking.getBody());
                        if (headers.get(HttpHeaderConstants.HOST) == null) {
                            headers.set(HttpHeaderConstants.HOST, host);
                        }
                        headers.set(HttpHeaderConstants.CONNECTION, "close");
                        int contentLength = request.content().readableBytes();
                        if (contentLength > 0) {
                            headers.set(HttpHeaderConstants.CONTENT_LENGTH, Integer.toString(contentLength, 10));
                        }
                        HttpHeaders requestHeaders = request.headers();
                        for (String name : headers.getNames()) {
                            requestHeaders.set(name, headers.getAll(name));
                        }
                        future.channel().writeAndFlush((Object)request).addListener((GenericFutureListener)new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                if (!future.isSuccess()) {
                                    future.channel().close();
                                    fulfiller.error(future.cause());
                                }
                            }
                        });
                    } else {
                        future.channel().close();
                        fulfiller.error(future.cause());
                    }
                }
            });
        }

        private static boolean isRedirect(Status status) {
            int code = status.getCode();
            return code >= 300 && code < 400;
        }
    }

    private static class Post
    implements Action<RequestSpec> {
        private Post() {
        }

        @Override
        public void execute(RequestSpec requestSpec) throws Exception {
            requestSpec.method("POST");
        }
    }
}

