/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client.internal;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import ratpack.func.Action;
import ratpack.http.HttpUrlSpec;
import ratpack.http.MutableHeaders;
import ratpack.http.client.RequestSpec;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.http.internal.HttpUrlSpecBacking;
import ratpack.util.internal.ByteBufWriteThroughOutputStream;

public class RequestSpecBacking {
    private final MutableHeaders headers;
    private final ByteBufAllocator byteBufAllocator;
    private final HttpUrlSpecBacking httpUrlSpec;
    private ByteBuf bodyByteBuf;
    private String method = "GET";
    private int maxRedirects = 10;

    public RequestSpecBacking(MutableHeaders headers, ByteBufAllocator byteBufAllocator) {
        this.headers = headers;
        this.byteBufAllocator = byteBufAllocator;
        this.httpUrlSpec = new HttpUrlSpecBacking();
        this.bodyByteBuf = byteBufAllocator.buffer(0, 0);
    }

    public String getMethod() {
        return this.method;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public ByteBuf getBody() {
        return this.bodyByteBuf;
    }

    public URI getUrl() {
        return this.httpUrlSpec.getURL();
    }

    public RequestSpec asSpec() {
        return new Spec();
    }

    private class Spec
    implements RequestSpec {
        private BodyImpl body = new BodyImpl();

        private Spec() {
        }

        @Override
        public RequestSpec redirects(int maxRedirects) {
            Preconditions.checkArgument((maxRedirects >= 0 ? 1 : 0) != 0);
            RequestSpecBacking.this.maxRedirects = maxRedirects;
            return this;
        }

        @Override
        public MutableHeaders getHeaders() {
            return RequestSpecBacking.this.headers;
        }

        @Override
        public RequestSpec headers(Action<? super MutableHeaders> action) throws Exception {
            action.execute(this.getHeaders());
            return this;
        }

        @Override
        public RequestSpec method(String method) {
            RequestSpecBacking.this.method = method.toUpperCase();
            return this;
        }

        @Override
        public HttpUrlSpec getUrl() {
            return RequestSpecBacking.this.httpUrlSpec;
        }

        @Override
        public RequestSpec url(Action<? super HttpUrlSpec> action) throws Exception {
            action.execute(this.getUrl());
            return this;
        }

        private void setBodyByteBuf(ByteBuf byteBuf) {
            if (RequestSpecBacking.this.bodyByteBuf != null) {
                RequestSpecBacking.this.bodyByteBuf.release();
            }
            RequestSpecBacking.this.bodyByteBuf = byteBuf;
        }

        @Override
        public RequestSpec.Body getBody() {
            return this.body;
        }

        @Override
        public RequestSpec body(Action<? super RequestSpec.Body> action) throws Exception {
            action.execute(this.getBody());
            return this;
        }

        private class BodyImpl
        implements RequestSpec.Body {
            private BodyImpl() {
            }

            @Override
            public RequestSpec.Body type(String contentType) {
                Spec.this.getHeaders().set(HttpHeaderConstants.CONTENT_TYPE, contentType);
                return this;
            }

            @Override
            public RequestSpec.Body stream(Action<? super OutputStream> action) throws Exception {
                ByteBuf byteBuf = RequestSpecBacking.this.byteBufAllocator.buffer();
                try (ByteBufWriteThroughOutputStream outputStream = new ByteBufWriteThroughOutputStream(byteBuf);){
                    action.execute(outputStream);
                }
                catch (Throwable t) {
                    byteBuf.release();
                    throw t;
                }
                Spec.this.setBodyByteBuf(byteBuf);
                return this;
            }

            @Override
            public RequestSpec.Body buffer(ByteBuf byteBuf) {
                Spec.this.setBodyByteBuf(byteBuf.retain());
                return this;
            }

            @Override
            public RequestSpec.Body bytes(byte[] bytes) {
                Spec.this.setBodyByteBuf(Unpooled.wrappedBuffer((byte[])bytes));
                return this;
            }

            @Override
            public RequestSpec.Body text(CharSequence text) {
                return this.text(text, CharsetUtil.UTF_8);
            }

            @Override
            public RequestSpec.Body text(CharSequence text, Charset charset) {
                if (charset.equals(CharsetUtil.UTF_8)) {
                    this.maybeSetContentType(HttpHeaderConstants.PLAIN_TEXT_UTF8);
                } else {
                    this.maybeSetContentType("text/plain;charset=" + charset.name());
                }
                Spec.this.setBodyByteBuf(Unpooled.copiedBuffer((CharSequence)text, (Charset)charset));
                return this;
            }

            private void maybeSetContentType(CharSequence s) {
                if (!RequestSpecBacking.this.headers.contains(HttpHeaderConstants.CONTENT_TYPE.toString())) {
                    RequestSpecBacking.this.headers.set(HttpHeaderConstants.CONTENT_TYPE, s);
                }
            }
        }
    }
}

