/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.internal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import ratpack.http.MediaType;
import ratpack.util.ExceptionUtils;

public class DefaultMediaType
implements MediaType {
    public static final String CHARSET_KEY = "charset";
    private final String type;
    protected final Map<String, String> params;
    private final String string;
    private static final int CACHE_SIZE = 200;
    private static final Cache<String, MediaType> CACHE = CacheBuilder.newBuilder().maximumSize(200L).build();

    public static MediaType get(String contentType) {
        String contentType1 = contentType;
        contentType1 = contentType1 == null ? "" : contentType1.trim();
        String finalContentType = contentType1;
        try {
            return (MediaType)CACHE.get((Object)contentType1, () -> new DefaultMediaType(finalContentType));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw ExceptionUtils.uncheck(ExceptionUtils.toException(e.getCause()));
        }
    }

    public DefaultMediaType(String value) {
        ImmutableMap.Builder paramsBuilder = ImmutableMap.builder();
        if (value == null) {
            this.type = null;
        } else if ((value = value.trim()).length() == 0) {
            this.type = null;
        } else {
            String[] parts = value.split(";");
            this.type = parts[0].toLowerCase();
            if (parts.length > 1) {
                for (int i = 1; i < parts.length; ++i) {
                    String valuePart;
                    String keyPart;
                    String part = parts[i].trim();
                    if (part.contains("=")) {
                        String[] valueSplit = part.split("=", 2);
                        keyPart = valueSplit[0].toLowerCase();
                        valuePart = valueSplit[1];
                    } else {
                        keyPart = part.toLowerCase();
                        valuePart = "";
                    }
                    paramsBuilder.put((Object)keyPart, (Object)valuePart);
                }
            }
        }
        this.params = paramsBuilder.build();
        this.string = this.generateString();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Map<String, String> getParams() {
        return Collections.unmodifiableMap(this.params);
    }

    @Override
    public String getCharset() {
        return this.params.get(CHARSET_KEY);
    }

    @Override
    public String getCharset(String defaultCharset) {
        return this.params.containsKey(CHARSET_KEY) ? this.params.get(CHARSET_KEY) : defaultCharset;
    }

    @Override
    public boolean isText() {
        return this.getType() != null && this.getType().startsWith("text/");
    }

    @Override
    public boolean isJson() {
        return this.getType() != null && this.getType().equals("application/json");
    }

    @Override
    public boolean isForm() {
        return this.getType() != null && this.getType().equals("application/x-www-form-urlencoded");
    }

    @Override
    public boolean isHtml() {
        return this.getType() != null && this.getType().equals("text/html");
    }

    @Override
    public boolean isEmpty() {
        return this.getType() == null;
    }

    public String toString() {
        return this.string;
    }

    private String generateString() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder s = new StringBuilder(this.getType());
        for (Map.Entry<String, String> param : this.getParams().entrySet()) {
            s.append(";").append(param.getKey());
            if (param.getValue().isEmpty()) continue;
            s.append("=").append(param.getValue());
        }
        return s.toString();
    }
}

