/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.internal;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.reflect.TypeToken;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.CookieDecoder;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import ratpack.func.Action;
import ratpack.http.Headers;
import ratpack.http.HttpMethod;
import ratpack.http.Request;
import ratpack.http.TypedData;
import ratpack.http.internal.ByteBufBackedTypedData;
import ratpack.http.internal.DefaultHttpMethod;
import ratpack.http.internal.DefaultMediaType;
import ratpack.registry.MutableRegistry;
import ratpack.registry.NotInRegistryException;
import ratpack.registry.internal.SimpleMutableRegistry;
import ratpack.util.MultiValueMap;
import ratpack.util.internal.ImmutableDelegatingMultiValueMap;

public class DefaultRequest
implements Request {
    private final MutableRegistry registry = new SimpleMutableRegistry();
    private final Headers headers;
    private final ByteBuf content;
    private final String rawUri;
    private TypedData body;
    private String uri;
    private ImmutableDelegatingMultiValueMap<String, String> queryParams;
    private String query;
    private String path;
    private final HttpMethod method;
    private Set<Cookie> cookies;

    public DefaultRequest(Headers headers, String methodName, String rawUri, ByteBuf content) {
        this.headers = headers;
        this.content = content;
        this.method = new DefaultHttpMethod(methodName);
        this.rawUri = rawUri;
    }

    @Override
    public MultiValueMap<String, String> getQueryParams() {
        if (this.queryParams == null) {
            QueryStringDecoder queryStringDecoder = new QueryStringDecoder(this.getUri());
            this.queryParams = new ImmutableDelegatingMultiValueMap(queryStringDecoder.parameters());
        }
        return this.queryParams;
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public String getRawUri() {
        return this.rawUri;
    }

    @Override
    public String getUri() {
        if (this.uri == null) {
            if (this.rawUri.startsWith("/")) {
                this.uri = this.rawUri;
            } else {
                URI parsed = URI.create(this.rawUri);
                String path = parsed.getPath();
                if (Strings.isNullOrEmpty((String)path)) {
                    path = "/";
                }
                StringBuilder sb = new StringBuilder();
                sb.append(path);
                if (parsed.getQuery() != null) {
                    sb.append("?").append(parsed.getQuery());
                }
                if (parsed.getFragment() != null) {
                    sb.append("#").append(parsed.getFragment());
                }
                this.uri = sb.toString();
            }
        }
        return this.uri;
    }

    @Override
    public String getQuery() {
        if (this.query == null) {
            String uri = this.getUri();
            int i = uri.indexOf("?");
            this.query = i < 0 || i == uri.length() ? "" : uri.substring(i + 1);
        }
        return this.query;
    }

    @Override
    public String getPath() {
        if (this.path == null) {
            String uri = this.getUri();
            String noSlash = uri.substring(1);
            int i = noSlash.indexOf("?");
            this.path = i < 0 ? noSlash : noSlash.substring(0, i);
        }
        return this.path;
    }

    @Override
    public Set<Cookie> getCookies() {
        if (this.cookies == null) {
            String header = this.headers.get("Cookie");
            this.cookies = header == null || header.length() == 0 ? Collections.emptySet() : CookieDecoder.decode((String)header);
        }
        return this.cookies;
    }

    @Override
    public String oneCookie(String name) {
        Cookie found = null;
        ArrayList<Cookie> allFound = null;
        for (Cookie cookie : this.getCookies()) {
            if (!cookie.getName().equals(name)) continue;
            if (found == null) {
                found = cookie;
                continue;
            }
            if (allFound == null) {
                allFound = new ArrayList<Cookie>(2);
                allFound.add(found);
                continue;
            }
            allFound.add(cookie);
        }
        if (found == null) {
            return null;
        }
        if (allFound != null) {
            StringBuilder s = new StringBuilder("Multiple cookies with name '").append(name).append("': ");
            int i = 0;
            for (Cookie cookie : allFound) {
                s.append(cookie.toString());
                if (++i >= allFound.size()) continue;
                s.append(", ");
            }
            throw new IllegalStateException(s.toString());
        }
        return found.getValue();
    }

    @Override
    public TypedData getBody() {
        if (this.body == null) {
            this.body = new ByteBufBackedTypedData(this.content, DefaultMediaType.get(this.headers.get("Content-Type")));
        }
        return this.body;
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }

    @Override
    public <O> Request addLazy(TypeToken<O> type, Supplier<? extends O> supplier) {
        this.registry.addLazy(type, supplier);
        return this;
    }

    @Override
    public <O> Request add(TypeToken<? super O> type, O object) {
        this.registry.add(type, object);
        return this;
    }

    @Override
    public <T> void remove(TypeToken<T> type) throws NotInRegistryException {
        this.registry.remove(type);
    }

    @Override
    public <O> O maybeGet(TypeToken<O> type) {
        return this.registry.maybeGet(type);
    }

    @Override
    public <O> Iterable<? extends O> getAll(TypeToken<O> type) {
        return this.registry.getAll(type);
    }

    @Override
    public <T> T first(TypeToken<T> type, Predicate<? super T> predicate) {
        return this.registry.first(type, predicate);
    }

    @Override
    public <T> Iterable<? extends T> all(TypeToken<T> type, Predicate<? super T> predicate) {
        return this.registry.all(type, predicate);
    }

    @Override
    public <T> boolean each(TypeToken<T> type, Predicate<? super T> predicate, Action<? super T> action) throws Exception {
        return this.registry.each(type, predicate, action);
    }
}

