/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.internal;

import com.google.common.collect.ImmutableMap;
import io.netty.handler.codec.http.HttpHeaders;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ratpack.http.Headers;
import ratpack.http.internal.HttpHeaderDateFormat;
import ratpack.util.MultiValueMap;
import ratpack.util.internal.ImmutableDelegatingMultiValueMap;

public class NettyHeadersBackedHeaders
implements Headers {
    protected final HttpHeaders headers;

    public NettyHeadersBackedHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    @Override
    public String get(CharSequence name) {
        return this.headers.get(name);
    }

    @Override
    public String get(String name) {
        return this.headers.get(name);
    }

    @Override
    public Date getDate(CharSequence name) {
        String value = this.get(name);
        if (value == null) {
            return null;
        }
        try {
            return HttpHeaderDateFormat.get().parse(value);
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Override
    public Date getDate(String name) {
        return this.getDate((CharSequence)name);
    }

    @Override
    public List<String> getAll(String name) {
        return this.headers.getAll(name);
    }

    @Override
    public boolean contains(String name) {
        return this.headers.contains(name);
    }

    @Override
    public List<String> getAll(CharSequence name) {
        return this.headers.getAll(name);
    }

    @Override
    public boolean contains(CharSequence name) {
        return this.headers.contains(name);
    }

    @Override
    public Set<String> getNames() {
        return this.headers.names();
    }

    @Override
    public MultiValueMap<String, String> asMultiValueMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String s : this.headers.names()) {
            builder.put((Object)s, (Object)this.headers.getAll(s));
        }
        return new ImmutableDelegatingMultiValueMap<String, String>((Map<String, List<String>>)builder.build());
    }

    @Override
    public HttpHeaders getNettyHeaders() {
        return this.headers;
    }
}

