/*
 * Decompiled with CFR 0.152.
 */
package ratpack.launch;

import com.google.common.base.StandardSystemProperty;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import ratpack.launch.LaunchConfig;
import ratpack.launch.internal.LaunchConfigsInternal;
import ratpack.util.internal.PropertiesUtil;

public abstract class LaunchConfigs {
    public static final String SYSPROP_PREFIX_PROPERTY = "ratpack.syspropPrefix";
    public static final String SYSPROP_PREFIX_DEFAULT = "ratpack.";
    public static final String CONFIG_RESOURCE_PROPERTY = "configResource";
    public static final String CONFIG_RESOURCE_DEFAULT = "ratpack.properties";

    private LaunchConfigs() {
    }

    public static LaunchConfig createFromGlobalProperties(ClassLoader classLoader, Properties globalProperties, Properties defaultProperties) {
        return LaunchConfigsInternal.createLaunchConfig(LaunchConfigsInternal.createFromGlobalProperties(StandardSystemProperty.USER_DIR.value(), classLoader, globalProperties, defaultProperties));
    }

    public static LaunchConfig createFromGlobalProperties(ClassLoader classLoader, String propertyPrefix, Properties globalProperties, Properties defaultProperties) {
        return LaunchConfigsInternal.createLaunchConfig(LaunchConfigsInternal.createFromGlobalProperties(StandardSystemProperty.USER_DIR.value(), classLoader, propertyPrefix, globalProperties, defaultProperties));
    }

    public static Properties getDefaultPrefixedProperties() {
        Properties deprefixed = new Properties();
        PropertiesUtil.extractProperties(SYSPROP_PREFIX_DEFAULT, System.getProperties(), deprefixed);
        return deprefixed;
    }

    public static LaunchConfig createFromProperties(ClassLoader classLoader, Properties overrideProperties, Properties defaultProperties) {
        return LaunchConfigsInternal.createLaunchConfig(LaunchConfigsInternal.createFromProperties(StandardSystemProperty.USER_DIR.value(), classLoader, overrideProperties, defaultProperties));
    }

    public static LaunchConfig createFromFile(ClassLoader classLoader, Path baseDir, Path configFile, Properties overrideProperties, Properties defaultProperties) {
        return LaunchConfigsInternal.createLaunchConfig(LaunchConfigsInternal.createFromFile(classLoader, baseDir, configFile, overrideProperties, defaultProperties));
    }

    public static LaunchConfig createWithBaseDir(ClassLoader classLoader, Path baseDir, Properties properties) {
        return LaunchConfigsInternal.createLaunchConfig(LaunchConfigsInternal.createWithBaseDir(classLoader, baseDir, properties));
    }

    public static LaunchConfig createWithBaseDir(ClassLoader classLoader, Path baseDir, Properties properties, Map<String, String> envVars) {
        return LaunchConfigsInternal.createLaunchConfig(LaunchConfigsInternal.createWithBaseDir(classLoader, baseDir, properties, envVars));
    }

    public final class Property {
        public static final String PORT = "port";
        public static final String ADDRESS = "address";
        public static final String DEVELOPMENT = "development";
        public static final String HANDLER_FACTORY = "handlerFactory";
        public static final String THREADS = "threads";
        public static final String PUBLIC_ADDRESS = "publicAddress";
        public static final String INDEX_FILES = "indexFiles";
        public static final String SSL_KEYSTORE_FILE = "ssl.keystore.file";
        public static final String SSL_KEYSTORE_PASSWORD = "ssl.keystore.password";
        public static final String MAX_CONTENT_LENGTH = "maxContentLength";
        public static final String TIME_RESPONSES = "timeResponses";
        public static final String COMPRESS_RESPONSES = "compressResponses";
        public static final String COMPRESSION_MIN_SIZE = "compression.minSize";
        public static final String COMPRESSION_MIME_TYPE_WHITE_LIST = "compression.mimeType.whiteList";
        public static final String COMPRESSION_MIME_TYPE_BLACK_LIST = "compression.mimeType.blackList";

        private Property() {
        }
    }

    public final class Environment {
        public static final String PORT = "PORT";

        private Environment() {
        }
    }
}

