/*
 * Decompiled with CFR 0.152.
 */
package ratpack.launch.internal;

import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import ratpack.util.internal.PropertiesUtil;

public class LaunchConfigData {
    private final ClassLoader classLoader;
    private final Path baseDir;
    private final Properties properties;
    private final Map<String, String> envVars;

    public LaunchConfigData(ClassLoader classLoader, Path baseDir, Properties properties, Map<String, String> envVars) {
        this.classLoader = classLoader;
        this.baseDir = baseDir;
        this.properties = properties;
        this.envVars = envVars;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Path getBaseDir() {
        return this.baseDir;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Map<String, String> getEnvVars() {
        return this.envVars;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LaunchConfigData that = (LaunchConfigData)o;
        return Objects.equals(this.baseDir, that.baseDir) && Objects.equals(this.classLoader, that.classLoader) && Objects.equals(this.envVars, that.envVars) && PropertiesUtil.flatEquals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.baseDir, this.classLoader, this.envVars, this.properties);
    }
}

