/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry;

import com.google.common.base.Predicate;
import com.google.common.reflect.TypeToken;
import ratpack.func.Action;
import ratpack.registry.NotInRegistryException;

public interface Registry {
    default public <O> O get(Class<O> type) throws NotInRegistryException {
        return this.get(TypeToken.of(type));
    }

    default public <O> O get(TypeToken<O> type) throws NotInRegistryException {
        O object = this.maybeGet(type);
        if (object == null) {
            throw new NotInRegistryException(type);
        }
        return object;
    }

    default public <O> O maybeGet(Class<O> type) {
        return this.maybeGet(TypeToken.of(type));
    }

    public <O> O maybeGet(TypeToken<O> var1);

    default public <O> Iterable<? extends O> getAll(Class<O> type) {
        return this.getAll(TypeToken.of(type));
    }

    public <O> Iterable<? extends O> getAll(TypeToken<O> var1);

    public <T> T first(TypeToken<T> var1, Predicate<? super T> var2);

    public <T> Iterable<? extends T> all(TypeToken<T> var1, Predicate<? super T> var2);

    public <T> boolean each(TypeToken<T> var1, Predicate<? super T> var2, Action<? super T> var3) throws Exception;
}

