/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry.internal;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import ratpack.func.Action;
import ratpack.registry.Registry;

public class HierarchicalRegistry
implements Registry {
    private final Registry parent;
    private final Registry child;

    public HierarchicalRegistry(Registry parent, Registry child) {
        this.parent = parent;
        this.child = child;
    }

    @Override
    public <O> O maybeGet(TypeToken<O> type) {
        O object = this.child.maybeGet(type);
        if (object == null) {
            object = this.parent.maybeGet(type);
        }
        return object;
    }

    @Override
    public <O> Iterable<? extends O> getAll(TypeToken<O> type) {
        Iterable<O> childAll = this.child.getAll(type);
        Iterable<O> parentAll = this.parent.getAll(type);
        return Iterables.concat(childAll, parentAll);
    }

    @Override
    public <T> T first(TypeToken<T> type, Predicate<? super T> predicate) {
        T first = this.child.first(type, predicate);
        if (first == null) {
            first = this.parent.first(type, predicate);
        }
        return first;
    }

    @Override
    public <T> Iterable<? extends T> all(TypeToken<T> type, Predicate<? super T> predicate) {
        Iterable<? super T> childAll = this.child.all(type, predicate);
        Iterable<? super T> parentAll = this.parent.all(type, predicate);
        return Iterables.concat(childAll, parentAll);
    }

    @Override
    public <T> boolean each(TypeToken<T> type, Predicate<? super T> predicate, Action<? super T> action) throws Exception {
        boolean childFound = this.child.each(type, predicate, action);
        boolean parentFound = this.parent.each(type, predicate, action);
        return childFound || parentFound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HierarchicalRegistry that = (HierarchicalRegistry)o;
        return this.child.equals(that.child) && this.parent.equals(that.parent);
    }

    public int hashCode() {
        int result = this.parent.hashCode();
        result = 31 * result + this.child.hashCode();
        return result;
    }

    public String toString() {
        return "HierarchicalRegistry{parent=" + this.parent + ", child=" + this.child + '}';
    }
}

