/*
 * Decompiled with CFR 0.152.
 */
package ratpack.stream.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import ratpack.func.Action;

public class GatedPublisher<T>
implements Publisher<T> {
    private final Publisher<T> upstream;
    private final Action<? super Runnable> releaseReceiver;

    public GatedPublisher(Publisher<T> upstream, Action<? super Runnable> releaseReceiver) {
        this.upstream = upstream;
        this.releaseReceiver = releaseReceiver;
    }

    public void subscribe(final Subscriber<? super T> downstream) {
        GatedSubscriber gatedSubscriber = new GatedSubscriber(downstream);
        try {
            this.releaseReceiver.execute(() -> gatedSubscriber.open());
        }
        catch (Throwable e) {
            downstream.onSubscribe(new Subscription(){

                public void request(long n) {
                    downstream.onError(e);
                }

                public void cancel() {
                }
            });
        }
        this.upstream.subscribe(gatedSubscriber);
    }

    private static class GatedSubscriber<T>
    implements Subscriber<T> {
        private Subscription upstreamSubscription;
        private final Subscriber<T> downstream;
        private final AtomicBoolean open = new AtomicBoolean();
        private final AtomicBoolean done = new AtomicBoolean();
        private final AtomicBoolean draining = new AtomicBoolean();
        private final AtomicLong waiting = new AtomicLong();

        public GatedSubscriber(Subscriber<T> downstream) {
            this.downstream = downstream;
        }

        private void open() {
            this.open.set(true);
            this.drain();
        }

        private void drain() {
            if (this.draining.compareAndSet(false, true)) {
                try {
                    if (this.open.get()) {
                        long requested = this.waiting.getAndSet(0L);
                        this.upstreamSubscription.request(requested);
                    }
                }
                finally {
                    this.draining.set(false);
                }
            }
            if (this.open.get() && this.waiting.get() > 0L) {
                this.drain();
            }
        }

        public void onSubscribe(Subscription s) {
            this.upstreamSubscription = s;
            this.downstream.onSubscribe((Subscription)new DownstreamSubscription());
        }

        public void onNext(T t) {
            this.downstream.onNext(t);
        }

        public void onError(Throwable t) {
            this.downstream.onError(t);
        }

        public void onComplete() {
            this.downstream.onComplete();
        }

        private class DownstreamSubscription
        implements Subscription {
            private DownstreamSubscription() {
            }

            public void request(long n) {
                if (GatedSubscriber.this.open.get() && !GatedSubscriber.this.done.get()) {
                    GatedSubscriber.this.upstreamSubscription.request(n);
                } else {
                    GatedSubscriber.this.waiting.addAndGet(n);
                }
            }

            public void cancel() {
                GatedSubscriber.this.upstreamSubscription.cancel();
            }
        }
    }
}

