/*
 * Decompiled with CFR 0.152.
 */
package ratpack.health.internal;

import ratpack.handling.Context;
import ratpack.health.HealthCheckResults;
import ratpack.render.RendererSupport;

public class HealthCheckResultsRenderer
extends RendererSupport<HealthCheckResults> {
    @Override
    public void render(Context context, HealthCheckResults healthCheckResults) throws Exception {
        StringBuilder builder = new StringBuilder();
        healthCheckResults.getResults().forEach((name, result) -> {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append((String)name).append(" : ").append(result.isHealthy() ? "HEALTHY" : "UNHEALTHY");
            if (!result.isHealthy()) {
                builder.append(" [").append(result.getMessage()).append("]");
                if (result.getError() != null) {
                    builder.append(" [").append(result.getError().toString()).append("]");
                }
            }
        });
        context.getResponse().send(builder.toString());
    }
}

