/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client;

import io.netty.buffer.ByteBufAllocator;
import java.net.URI;
import ratpack.exec.Promise;
import ratpack.func.Action;
import ratpack.http.client.ReceivedResponse;
import ratpack.http.client.RequestSpec;
import ratpack.http.client.StreamedResponse;
import ratpack.http.client.internal.DefaultHttpClient;
import ratpack.registry.Registry;
import ratpack.server.ServerConfig;

public interface HttpClient {
    public static HttpClient httpClient(ServerConfig serverConfig, Registry registry) {
        return new DefaultHttpClient(registry.get(ByteBufAllocator.class), serverConfig.getMaxContentLength());
    }

    public static HttpClient httpClient(ByteBufAllocator byteBufAllocator, int maxContentLengthBytes) {
        return new DefaultHttpClient(byteBufAllocator, maxContentLengthBytes);
    }

    public Promise<ReceivedResponse> get(URI var1, Action<? super RequestSpec> var2);

    default public Promise<ReceivedResponse> get(URI uri) {
        return this.get(uri, Action.noop());
    }

    public Promise<ReceivedResponse> post(URI var1, Action<? super RequestSpec> var2);

    public Promise<ReceivedResponse> request(URI var1, Action<? super RequestSpec> var2);

    public Promise<StreamedResponse> requestStream(URI var1, Action<? super RequestSpec> var2);
}

