/*
 * Decompiled with CFR 0.152.
 */
package ratpack.logging;

import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.MDC;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.Execution;
import ratpack.func.Block;
import ratpack.util.Types;

public class MDCInterceptor
implements ExecInterceptor {
    private static final MDCInterceptor INSTANCE = new MDCInterceptor();

    public static MDCInterceptor instance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void intercept(Execution execution, ExecInterceptor.ExecType type, Block executionSegment) throws Exception {
        MDC.clear();
        MDCMap map = execution.maybeGet(MDCMap.class).orElse(null);
        if (map == null) {
            map = new MDCMap();
            execution.add(map);
        } else {
            MDC.setContextMap((Map)map);
        }
        try {
            executionSegment.execute();
        }
        finally {
            map.clear();
            Map ctxMap = (Map)Types.cast(MDC.getCopyOfContextMap());
            if (ctxMap != null && ctxMap.size() > 0) {
                map.putAll(ctxMap);
                MDC.clear();
            }
        }
    }

    private static class MDCMap
    extends LinkedHashMap<String, String> {
        private MDCMap() {
        }
    }
}

