/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry.internal;

import com.google.common.reflect.TypeToken;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import ratpack.func.Function;
import ratpack.registry.Registry;
import ratpack.registry.internal.RegistryEntry;
import ratpack.util.Types;

public class MultiEntryRegistry
implements Registry {
    private final List<? extends RegistryEntry<?>> entries;

    public MultiEntryRegistry(List<? extends RegistryEntry<?>> entries) {
        this.entries = entries;
    }

    public String toString() {
        return "Registry{" + this.entries + '}';
    }

    @Override
    public <O> Optional<O> maybeGet(TypeToken<O> type) {
        for (RegistryEntry<?> entry : this.entries) {
            if (!type.isAssignableFrom(entry.getType())) continue;
            Object cast = entry.get();
            return Optional.of(cast);
        }
        return Optional.empty();
    }

    @Override
    public <O> Iterable<? extends O> getAll(final TypeToken<O> type) {
        return new Iterable<O>(){

            @Override
            public Iterator<O> iterator() {
                return new Iterator<O>(){
                    final Iterator<? extends RegistryEntry<?>> delegate;
                    O next;
                    {
                        this.delegate = MultiEntryRegistry.this.entries.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.next != null) {
                            return true;
                        }
                        while (this.delegate.hasNext()) {
                            RegistryEntry<?> entry = this.delegate.next();
                            if (!type.isAssignableFrom(entry.getType())) continue;
                            Object cast = entry.get();
                            this.next = cast;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public O next() {
                        Object nextCopy = this.next;
                        this.next = null;
                        return nextCopy;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public <T, O> Optional<O> first(TypeToken<T> type, Function<? super T, ? extends O> function) throws Exception {
        for (RegistryEntry<?> entry : this.entries) {
            RegistryEntry cast;
            O result;
            if (!type.isAssignableFrom(entry.getType()) || (result = function.apply((cast = (RegistryEntry)Types.cast(entry)).get())) == null) continue;
            return Optional.of(result);
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiEntryRegistry that = (MultiEntryRegistry)o;
        return this.entries.equals(that.entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }
}

