/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.reflect.TypeToken;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.ResourceLeakDetector;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.exec.Blocking;
import ratpack.exec.Promise;
import ratpack.exec.Throttle;
import ratpack.exec.internal.DefaultExecController;
import ratpack.func.Action;
import ratpack.func.BiAction;
import ratpack.func.Function;
import ratpack.handling.Handler;
import ratpack.handling.HandlerDecorator;
import ratpack.registry.Registry;
import ratpack.server.RatpackServer;
import ratpack.server.RatpackServerSpec;
import ratpack.server.ReloadInformant;
import ratpack.server.ServerConfig;
import ratpack.server.Service;
import ratpack.server.StartupFailureException;
import ratpack.server.internal.DefaultEvent;
import ratpack.server.internal.DelegatingServerConfig;
import ratpack.server.internal.HostUtil;
import ratpack.server.internal.NettyHandlerAdapter;
import ratpack.server.internal.RatpackServerDefinition;
import ratpack.server.internal.ServerCapturer;
import ratpack.server.internal.ServerRegistry;
import ratpack.server.internal.SmartHttpContentCompressor;
import ratpack.util.Exceptions;
import ratpack.util.internal.ChannelImplDetector;

public class DefaultRatpackServer
implements RatpackServer {
    public static final TypeToken<HandlerDecorator> HANDLER_DECORATOR_TYPE_TOKEN;
    public static final Logger LOGGER;
    protected final Action<? super RatpackServerSpec> definitionFactory;
    protected InetSocketAddress boundAddress;
    protected Channel channel;
    protected DefaultExecController execController;
    protected Registry serverRegistry = Registry.empty();
    protected boolean reloading;
    protected final AtomicBoolean needsReload = new AtomicBoolean();
    protected boolean useSsl;
    private final ServerCapturer.Overrides overrides;
    private Thread shutdownHookThread;

    public DefaultRatpackServer(Action<? super RatpackServerSpec> definitionFactory) throws Exception {
        this.definitionFactory = definitionFactory;
        this.overrides = ServerCapturer.capture(this);
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.isRunning()) {
            return;
        }
        LOGGER.info("Starting server...");
        DefinitionBuild definitionBuild = this.buildUserDefinition();
        if (definitionBuild.error != null) {
            if (definitionBuild.getServerConfig().isDevelopment()) {
                LOGGER.warn("Exception raised getting server config (will use default config until reload):", definitionBuild.error);
                this.needsReload.set(true);
            } else {
                throw Exceptions.toException(definitionBuild.error);
            }
        }
        ServerConfig serverConfig = definitionBuild.getServerConfig();
        this.execController = new DefaultExecController(serverConfig.getThreads());
        ChannelHandler channelHandler = this.buildHandler(definitionBuild);
        this.channel = this.buildChannel(serverConfig, channelHandler);
        this.boundAddress = (InetSocketAddress)this.channel.localAddress();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("Ratpack started %sfor %s://%s:%s", serverConfig.isDevelopment() ? "(development) " : "", this.getScheme(), this.getBindHost(), this.getBindPort()));
        }
        this.shutdownHookThread = new Thread("ratpack-shutdown-thread"){

            @Override
            public void run() {
                try {
                    DefaultRatpackServer.this.stop();
                }
                catch (Exception ignored) {
                    ignored.printStackTrace(System.err);
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
    }

    protected DefinitionBuild buildUserDefinition() throws Exception {
        try {
            return new DefinitionBuild(this.overrides, RatpackServerDefinition.build(this.definitionFactory), null);
        }
        catch (Exception e) {
            return new DefinitionBuild(this.overrides, RatpackServerDefinition.build(s -> s.handler(r -> ctx -> ctx.error(e))), e);
        }
    }

    private ChannelHandler buildHandler(DefinitionBuild definitionBuild) throws Exception {
        if (definitionBuild.getServerConfig().isDevelopment()) {
            return new ReloadHandler(definitionBuild);
        }
        return this.buildAdapter(definitionBuild);
    }

    protected Channel buildChannel(final ServerConfig serverConfig, final ChannelHandler handlerAdapter) throws InterruptedException {
        final SSLContext sslContext = serverConfig.getSslContext();
        final boolean requireClientSslAuth = serverConfig.isRequireClientSslAuth();
        this.useSsl = sslContext != null;
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        serverConfig.getConnectTimeoutMillis().ifPresent(i -> {
            serverBootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, i);
            serverBootstrap.childOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, i);
        });
        serverConfig.getMaxMessagesPerRead().ifPresent(i -> {
            serverBootstrap.option(ChannelOption.MAX_MESSAGES_PER_READ, i);
            serverBootstrap.childOption(ChannelOption.MAX_MESSAGES_PER_READ, i);
        });
        serverConfig.getReceiveBufferSize().ifPresent(i -> {
            serverBootstrap.option(ChannelOption.SO_RCVBUF, i);
            serverBootstrap.childOption(ChannelOption.SO_RCVBUF, i);
        });
        serverConfig.getWriteSpinCount().ifPresent(i -> {
            serverBootstrap.option(ChannelOption.WRITE_SPIN_COUNT, i);
            serverBootstrap.childOption(ChannelOption.WRITE_SPIN_COUNT, i);
        });
        return ((ServerBootstrap)((ServerBootstrap)serverBootstrap.group(this.execController.getEventLoopGroup()).channel(ChannelImplDetector.getServerSocketChannelImpl())).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                if (sslContext != null) {
                    SSLEngine sslEngine = sslContext.createSSLEngine();
                    sslEngine.setUseClientMode(false);
                    sslEngine.setNeedClientAuth(requireClientSslAuth);
                    pipeline.addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
                }
                pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder(4096, 8192, 8192, false));
                pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
                pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(serverConfig.getMaxContentLength()));
                pipeline.addLast("deflater", (ChannelHandler)new SmartHttpContentCompressor());
                pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
                pipeline.addLast("adapter", handlerAdapter);
            }
        }).bind((SocketAddress)this.buildSocketAddress(serverConfig)).sync().channel();
    }

    protected NettyHandlerAdapter buildAdapter(DefinitionBuild definition) throws Exception {
        LOGGER.info("Building registry...");
        this.serverRegistry = this.buildServerRegistry(definition.getServerConfig(), definition.getUserRegistryFactory());
        Handler ratpackHandler = this.buildRatpackHandler(this.serverRegistry, definition.getHandlerFactory());
        ratpackHandler = this.decorateHandler(ratpackHandler, this.serverRegistry);
        LinkedHashSet services = Sets.newLinkedHashSet(this.serverRegistry.getAll(Service.class));
        if (!services.isEmpty()) {
            LOGGER.info("Initializing " + services.size() + " services...");
            try {
                this.executeEvents(services.iterator(), new DefaultEvent(this.serverRegistry, this.reloading), Service::onStart, (service, error) -> {
                    throw new StartupFailureException("Service '" + service.getName() + "' failed startup", (Throwable)error);
                });
            }
            catch (StartupFailureException e) {
                try {
                    this.shutdownServices();
                }
                catch (Exception e1) {
                    e.addSuppressed(e1);
                }
                throw e;
            }
        }
        return new NettyHandlerAdapter(this.serverRegistry, ratpackHandler);
    }

    private Registry buildServerRegistry(ServerConfig serverConfig, Function<? super Registry, ? extends Registry> userRegistryFactory) {
        return ServerRegistry.serverRegistry(this, this.execController, serverConfig, userRegistryFactory);
    }

    private Handler decorateHandler(Handler rootHandler, Registry serverRegistry) throws Exception {
        Iterable<HandlerDecorator> all = serverRegistry.getAll(HANDLER_DECORATOR_TYPE_TOKEN);
        for (HandlerDecorator handlerDecorator : all) {
            rootHandler = handlerDecorator.decorate(serverRegistry, rootHandler);
        }
        return rootHandler;
    }

    private Handler buildRatpackHandler(Registry serverRegistry, Function<? super Registry, ? extends Handler> handlerFactory) throws Exception {
        return handlerFactory.apply(serverRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() throws Exception {
        block11: {
            if (!this.isRunning()) {
                return;
            }
            Channel lastChannel = this.channel;
            this.channel = null;
            try {
                if (this.shutdownHookThread != null) {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHookThread);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            LOGGER.info("Stopping server...");
            if (lastChannel != null) {
                lastChannel.close().sync();
            }
            try {
                if (this.execController == null) break block11;
                try {
                    this.shutdownServices();
                }
                finally {
                    this.execController.close();
                    this.execController.awaitShutdown();
                }
            }
            finally {
                this.execController = null;
            }
        }
        LOGGER.info("Server stopped.");
    }

    private void shutdownServices() throws Exception {
        if (this.serverRegistry != null) {
            LinkedHashSet services = Sets.newLinkedHashSet(this.serverRegistry.getAll(Service.class));
            if (services.isEmpty()) {
                return;
            }
            LOGGER.info("Stopping " + services.size() + " services...");
            UnmodifiableIterator reverseServices = ImmutableList.copyOf((Collection)services).reverse().iterator();
            this.executeEvents((Iterator<? extends Service>)reverseServices, new DefaultEvent(this.serverRegistry, this.reloading), Service::onStop, (service, error) -> LOGGER.warn("Service '" + service.getName() + "' thrown an exception while stopping.", error));
        }
    }

    @Override
    public synchronized RatpackServer reload() throws Exception {
        this.reloading = true;
        boolean start = false;
        if (this.isRunning()) {
            start = true;
            this.stop();
        }
        if (start) {
            this.start();
        }
        this.reloading = false;
        return this;
    }

    @Override
    public synchronized boolean isRunning() {
        return this.channel != null;
    }

    @Override
    public synchronized String getScheme() {
        return this.isRunning() ? (this.useSsl ? "https" : "http") : null;
    }

    @Override
    public synchronized int getBindPort() {
        return this.boundAddress == null ? -1 : this.boundAddress.getPort();
    }

    @Override
    public synchronized String getBindHost() {
        if (this.boundAddress == null) {
            return null;
        }
        return HostUtil.determineHost(this.boundAddress);
    }

    private InetSocketAddress buildSocketAddress(ServerConfig serverConfig) {
        return serverConfig.getAddress() == null ? new InetSocketAddress(serverConfig.getPort()) : new InetSocketAddress(serverConfig.getAddress(), serverConfig.getPort());
    }

    private <E> void executeEvents(Iterator<? extends Service> services, E event, BiAction<Service, E> action, BiAction<? super Service, ? super Throwable> onError) throws Exception {
        if (!services.hasNext()) {
            return;
        }
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference<Throwable> error = new AtomicReference<Throwable>();
        this.executeEvents(services, latch, error, event, action, onError);
        latch.await();
        Throwable thrown = error.get();
        if (thrown != null) {
            throw Exceptions.toException(thrown);
        }
    }

    private <E> void executeEvents(Iterator<? extends Service> services, CountDownLatch latch, AtomicReference<Throwable> error, E event, BiAction<Service, E> action, BiAction<? super Service, ? super Throwable> onError) throws Exception {
        if (services.hasNext()) {
            Service service = services.next();
            this.execController.fork().onError(t -> {
                try {
                    onError.execute(service, (Throwable)t);
                }
                catch (Throwable e) {
                    error.set(e);
                }
            }).onComplete(e -> {
                if (error.get() == null) {
                    this.executeEvents(services, latch, error, event, action, onError);
                } else {
                    latch.countDown();
                }
            }).start(e -> action.execute(service, event));
        } else {
            latch.countDown();
        }
    }

    static {
        if (System.getProperty("io.netty.leakDetectionLevel", null) == null) {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.DISABLED);
        }
        HANDLER_DECORATOR_TYPE_TOKEN = TypeToken.of(HandlerDecorator.class);
        LOGGER = LoggerFactory.getLogger(RatpackServer.class);
    }

    @ChannelHandler.Sharable
    private class ReloadHandler
    extends SimpleChannelInboundHandler<FullHttpRequest> {
        private ServerConfig lastServerConfig;
        private DefinitionBuild definitionBuild;
        private final Throttle reloadThrottle;
        private ChannelHandler inner;

        public ReloadHandler(DefinitionBuild definition) {
            super(false);
            this.reloadThrottle = Throttle.ofSize(1);
            this.definitionBuild = definition;
            this.lastServerConfig = this.definitionBuild.getServerConfig();
            try {
                this.inner = DefaultRatpackServer.this.buildAdapter(this.definitionBuild);
            }
            catch (Exception e) {
                this.inner = null;
                DefaultRatpackServer.this.serverRegistry = DefaultRatpackServer.this.buildServerRegistry(this.lastServerConfig, r -> r);
            }
        }

        protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) throws Exception {
            DefaultRatpackServer.this.execController.fork().start(e -> Promise.of(f -> {
                boolean rebuild = false;
                if (this.inner == null || this.definitionBuild.error != null) {
                    rebuild = true;
                } else {
                    Optional<ReloadInformant> reloadInformant = DefaultRatpackServer.this.serverRegistry.first(TypeToken.of(ReloadInformant.class), r -> r.shouldReload(DefaultRatpackServer.this.serverRegistry) ? r : null);
                    if (reloadInformant.isPresent()) {
                        LOGGER.warn("reload requested by '" + reloadInformant.get() + "'");
                        rebuild = true;
                    }
                }
                if (rebuild) {
                    Blocking.get(() -> {
                        this.definitionBuild = DefaultRatpackServer.this.buildUserDefinition();
                        this.lastServerConfig = this.definitionBuild.getServerConfig();
                        return DefaultRatpackServer.this.buildAdapter(this.definitionBuild);
                    }).wiretap(r -> {
                        if (r.isSuccess()) {
                            this.inner = (ChannelHandler)r.getValue();
                        }
                    }).mapError(this::buildErrorRenderingAdapter).result(f::accept);
                } else {
                    f.success(this.inner);
                }
            }).wiretap(r -> {
                try {
                    ctx.pipeline().remove("inner");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ctx.pipeline().addLast("inner", (ChannelHandler)r.getValueOrThrow());
            }).throttled(this.reloadThrottle).then(adapter -> ctx.fireChannelRead((Object)msg)));
        }

        private NettyHandlerAdapter buildErrorRenderingAdapter(Throwable e) {
            try {
                return new NettyHandlerAdapter(DefaultRatpackServer.this.serverRegistry, context -> context.error(e));
            }
            catch (Exception e1) {
                throw Exceptions.uncheck(e);
            }
        }
    }

    private static class DefinitionBuild {
        private final ServerCapturer.Overrides overrides;
        private final RatpackServerDefinition definition;
        private final Throwable error;
        private final ServerConfig serverConfig;
        private final Function<? super Registry, ? extends Registry> userRegistryFactory;

        public DefinitionBuild(final ServerCapturer.Overrides overrides, RatpackServerDefinition definition, Throwable error) {
            this.overrides = overrides;
            this.definition = definition;
            this.error = error;
            this.serverConfig = new DelegatingServerConfig(definition.getServerConfig()){

                @Override
                public int getPort() {
                    return overrides.getPort() < 0 ? super.getPort() : overrides.getPort();
                }

                @Override
                public boolean isDevelopment() {
                    return overrides.isDevelopment() == null ? super.isDevelopment() : overrides.isDevelopment().booleanValue();
                }
            };
            Registry serverConfigOverrideRegistry = Registry.single(ServerConfig.class, this.serverConfig);
            this.userRegistryFactory = baseRegistry -> {
                Registry actualBaseRegistry = baseRegistry.join(serverConfigOverrideRegistry);
                Registry userRegistry = definition.getRegistry().apply(actualBaseRegistry);
                Registry overrideRegistry = overrides.getRegistryFunction().apply(userRegistry);
                return userRegistry.join(overrideRegistry);
            };
        }

        public ServerCapturer.Overrides getOverrides() {
            return this.overrides;
        }

        public ServerConfig getServerConfig() {
            return this.serverConfig;
        }

        public Function<? super Registry, ? extends Registry> getUserRegistryFactory() {
            return this.userRegistryFactory;
        }

        public Function<? super Registry, ? extends Handler> getHandlerFactory() {
            return this.definition.getHandler();
        }
    }
}

