/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import com.google.common.collect.Iterables;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerEnvironment {
    public static final ServerEnvironment INSTANCE = new ServerEnvironment(System.getenv(), System.getProperties());
    public static final String DEVELOPMENT_PROPERTY = "ratpack.development";
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerEnvironment.class);
    private static final int MAX_PORT = 65535;
    public static final String PORT_PROPERTY = "ratpack.port";
    public static final String INTELLIJ_MAIN = "com.intellij.rt.execution.application.AppMain";
    public static final String INTELLIJ_JUNIT = "com.intellij.rt.execution.junit.JUnitStarter";
    private final Map<String, String> env;
    private final Properties properties;

    public ServerEnvironment(Map<String, String> env, Properties properties) {
        this.env = env;
        this.properties = properties;
    }

    public static ServerEnvironment env() {
        return INSTANCE;
    }

    @SafeVarargs
    private static <T> T get(T defaultValue, Predicate<? super T> accept, Supplier<T> ... suppliers) {
        return (T)Iterables.find((Iterable)Iterables.transform(Arrays.asList(suppliers), Supplier::get), accept::test, defaultValue);
    }

    public Map<String, String> getenv() {
        return this.env;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Integer getPort() {
        return ServerEnvironment.get(5050, i -> i != null, () -> ServerEnvironment.parsePortValue("ratpack.port system property", this.properties.getProperty(PORT_PROPERTY)), () -> ServerEnvironment.parsePortValue("RATPACK_PORT env var", this.env.get("RATPACK_PORT")), () -> ServerEnvironment.parsePortValue("PORT env var", this.env.get("PORT")));
    }

    public boolean isDevelopment() {
        return Boolean.parseBoolean(ServerEnvironment.get("false", i -> i != null, () -> this.properties.getProperty(DEVELOPMENT_PROPERTY), () -> this.env.get("RATPACK_DEVELOPMENT"), () -> {
            String command = System.getProperty("sun.java.command");
            return command.startsWith(INTELLIJ_MAIN) && !command.contains(INTELLIJ_JUNIT) ? "true" : null;
        }));
    }

    public URI getPublicAddress() {
        return ServerEnvironment.get(null, i -> i != null, () -> ServerEnvironment.parseUri("'ratpack.publicAddress' system property", this.properties.getProperty("ratpack.publicAddress")), () -> ServerEnvironment.parseUri("'RATPACK_PUBLIC_ADDRESS' env var", this.env.get("RATPACK_PUBLIC_ADDRESS")));
    }

    private static URI parseUri(String description, String value) {
        if (value != null) {
            try {
                URI uri = new URI(value);
                String scheme = uri.getScheme();
                if (scheme.equals("http") || scheme.equals("https")) {
                    return uri;
                }
                LOGGER.warn("Could not use {} value {} as it is not a http/https URI, ignoring value", (Object)description, (Object)value);
            }
            catch (URISyntaxException e) {
                LOGGER.warn("Could not convert {} with value {} to a URI ({}), ignoring value", new Object[]{description, value, e.getMessage()});
            }
        }
        return null;
    }

    public static Integer parsePortValue(String description, String value) {
        if (value == null) {
            return null;
        }
        try {
            int intValue = Integer.parseInt(value);
            if (intValue < 0 || intValue > 65535) {
                LOGGER.warn("{} value {} is outside of allowed range 0 - {}, using default of {}", new Object[]{description, intValue, 65535, 5050});
                return 5050;
            }
            return intValue;
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Failed to parse {} value {} to int, using default of {}", new Object[]{description, value, 5050});
            return 5050;
        }
    }
}

