/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client.internal;

import com.google.common.net.HostAndPort;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.PrematureChannelClosureException;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import ratpack.exec.Downstream;
import ratpack.exec.Execution;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.http.MutableHeaders;
import ratpack.http.client.ReceivedResponse;
import ratpack.http.client.RequestSpec;
import ratpack.http.client.internal.DefaultReceivedResponse;
import ratpack.http.client.internal.RequestAction;
import ratpack.http.client.internal.RequestParams;
import ratpack.http.client.internal.RequestSpecBacking;
import ratpack.http.internal.ByteBufBackedTypedData;
import ratpack.http.internal.DefaultMediaType;
import ratpack.http.internal.DefaultStatus;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.http.internal.NettyHeadersBackedHeaders;
import ratpack.http.internal.NettyHeadersBackedMutableHeaders;
import ratpack.util.Exceptions;
import ratpack.util.internal.ChannelImplDetector;

abstract class RequestActionSupport<T>
implements RequestAction<T> {
    private static final Pattern ABSOLUTE_PATTERN = Pattern.compile("^https?://.*");
    private final Action<? super RequestSpec> requestConfigurer;
    private final boolean finalUseSsl;
    private final String host;
    private final int port;
    private final MutableHeaders headers;
    private final RequestSpecBacking requestSpecBacking;
    private final URI uri;
    private final int redirectCounter;
    private final RequestParams requestParams;
    private final AtomicBoolean fired = new AtomicBoolean();
    protected final Execution execution;
    protected final ByteBufAllocator byteBufAllocator;

    public RequestActionSupport(Action<? super RequestSpec> requestConfigurer, URI uri, Execution execution, ByteBufAllocator byteBufAllocator, int redirectCounter) {
        this.execution = execution;
        this.requestConfigurer = requestConfigurer;
        this.byteBufAllocator = byteBufAllocator;
        this.uri = uri;
        this.redirectCounter = redirectCounter;
        this.requestParams = new RequestParams();
        this.headers = new NettyHeadersBackedMutableHeaders((HttpHeaders)new DefaultHttpHeaders());
        this.requestSpecBacking = new RequestSpecBacking(this.headers, uri, byteBufAllocator, this.requestParams);
        try {
            requestConfigurer.execute(this.requestSpecBacking.asSpec());
        }
        catch (Exception e) {
            throw Exceptions.uncheck(e);
        }
        String scheme = uri.getScheme();
        boolean useSsl = false;
        if (scheme.equals("https")) {
            useSsl = true;
        } else if (!scheme.equals("http")) {
            throw new IllegalArgumentException(String.format("URL '%s' is not a http url", uri.toString()));
        }
        this.finalUseSsl = useSsl;
        this.host = uri.getHost();
        this.port = uri.getPort() < 0 ? (useSsl ? 443 : 80) : uri.getPort();
    }

    private static ByteBuf initBufferReleaseOnExecutionClose(ByteBuf responseBuffer, Execution execution) {
        execution.onComplete(() -> ((ByteBuf)responseBuffer).release());
        return responseBuffer;
    }

    @Override
    public void connect(final Downstream<? super T> downstream) throws Exception {
        Bootstrap b = new Bootstrap();
        ((Bootstrap)((Bootstrap)b.group((EventLoopGroup)this.execution.getEventLoop())).channel(ChannelImplDetector.getSocketChannelImpl())).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                if (RequestActionSupport.this.finalUseSsl) {
                    SSLEngine sslEngine = RequestActionSupport.this.requestSpecBacking.getSslContext() != null ? RequestActionSupport.this.requestSpecBacking.getSslContext().createSSLEngine() : SSLContext.getDefault().createSSLEngine();
                    sslEngine.setUseClientMode(true);
                    p.addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
                }
                p.addLast("codec", (ChannelHandler)new HttpClientCodec());
                p.addLast("readTimeout", (ChannelHandler)new ReadTimeoutHandler(((RequestActionSupport)RequestActionSupport.this).requestParams.readTimeoutNanos, TimeUnit.NANOSECONDS));
                p.addLast("redirectHandler", (ChannelHandler)new SimpleChannelInboundHandler<HttpObject>(false){
                    boolean readComplete;
                    boolean redirected;

                    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                        if (!this.readComplete) {
                            RequestActionSupport.this.error(downstream, (Throwable)new PrematureChannelClosureException("Server " + RequestActionSupport.this.uri + " closed the connection prematurely"));
                        }
                        super.channelReadComplete(ctx);
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        super.exceptionCaught(ctx, cause);
                    }

                    protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
                        if (msg instanceof HttpResponse) {
                            this.readComplete = true;
                            HttpResponse response = (HttpResponse)msg;
                            int maxRedirects = RequestActionSupport.this.requestSpecBacking.getMaxRedirects();
                            int status = response.status().code();
                            String locationValue = response.headers().get(HttpHeaderConstants.LOCATION);
                            Action<RequestSpec> redirectConfigurer = RequestActionSupport.this.requestConfigurer;
                            if (RequestActionSupport.isRedirect(status) && RequestActionSupport.this.redirectCounter < maxRedirects && locationValue != null) {
                                Function<? super ReceivedResponse, Action<? super RequestSpec>> onRedirect = RequestActionSupport.this.requestSpecBacking.getOnRedirect();
                                if (onRedirect != null) {
                                    Action<? super RequestSpec> onRedirectResult = onRedirect.apply(RequestActionSupport.this.toReceivedResponse(response));
                                    redirectConfigurer = onRedirectResult == null ? null : redirectConfigurer.append(onRedirectResult);
                                }
                                if (redirectConfigurer != null) {
                                    Action<RequestSpec> redirectRequestConfig = s -> {
                                        if (status == 301 || status == 302) {
                                            s.method("GET");
                                        }
                                    };
                                    redirectRequestConfig = redirectRequestConfig.append(redirectConfigurer);
                                    URI locationUrl = ABSOLUTE_PATTERN.matcher(locationValue).matches() ? new URI(locationValue) : new URI(RequestActionSupport.this.uri.getScheme(), null, RequestActionSupport.this.uri.getHost(), RequestActionSupport.this.uri.getPort(), locationValue, null, null);
                                    RequestActionSupport.this.buildRedirectRequestAction(redirectRequestConfig, locationUrl, RequestActionSupport.this.redirectCounter + 1).connect(downstream);
                                    this.redirected = true;
                                }
                            }
                        }
                        if (!this.redirected) {
                            ctx.fireChannelRead((Object)msg);
                        }
                    }
                });
                if (RequestActionSupport.this.requestSpecBacking.isDecompressResponse()) {
                    p.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
                }
                RequestActionSupport.this.addResponseHandlers(p, downstream);
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                ctx.close();
                RequestActionSupport.this.error(downstream, cause);
            }
        });
        ChannelFuture connectFuture = b.connect(this.host, this.port);
        connectFuture.addListener(f1 -> {
            if (connectFuture.isSuccess()) {
                String fullPath = RequestActionSupport.getFullPath(this.uri);
                DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)this.requestSpecBacking.getMethod()), fullPath, this.requestSpecBacking.getBody());
                if (this.headers.get(HttpHeaderConstants.HOST) == null) {
                    HostAndPort hostAndPort = HostAndPort.fromParts((String)this.host, (int)this.port);
                    this.headers.set(HttpHeaderConstants.HOST, hostAndPort.toString());
                }
                this.headers.set(HttpHeaderConstants.CONNECTION, HttpHeaderValues.CLOSE);
                int contentLength = request.content().readableBytes();
                if (contentLength > 0) {
                    this.headers.set(HttpHeaderConstants.CONTENT_LENGTH, Integer.toString(contentLength));
                }
                HttpHeaders requestHeaders = request.headers();
                for (String name : this.headers.getNames()) {
                    requestHeaders.set(name, this.headers.getAll(name));
                }
                ChannelFuture writeFuture = connectFuture.channel().writeAndFlush((Object)request);
                writeFuture.addListener(f2 -> {
                    if (!writeFuture.isSuccess()) {
                        writeFuture.channel().close();
                        this.error(downstream, writeFuture.cause());
                    }
                });
            } else {
                connectFuture.channel().close();
                this.error(downstream, connectFuture.cause());
            }
        });
    }

    protected ReceivedResponse toReceivedResponse(FullHttpResponse msg) {
        return this.toReceivedResponse((HttpResponse)msg, RequestActionSupport.initBufferReleaseOnExecutionClose(msg.content(), this.execution));
    }

    protected ReceivedResponse toReceivedResponse(HttpResponse msg) {
        return this.toReceivedResponse(msg, this.byteBufAllocator.buffer(0, 0));
    }

    private ReceivedResponse toReceivedResponse(HttpResponse msg, ByteBuf responseBuffer) {
        NettyHeadersBackedHeaders headers = new NettyHeadersBackedHeaders(msg.headers());
        String contentType = headers.get(HttpHeaderConstants.CONTENT_TYPE.toString());
        ByteBufBackedTypedData typedData = new ByteBufBackedTypedData(responseBuffer, DefaultMediaType.get(contentType));
        DefaultStatus status = new DefaultStatus(msg.status());
        return new DefaultReceivedResponse(status, headers, typedData);
    }

    protected abstract RequestAction<T> buildRedirectRequestAction(Action<? super RequestSpec> var1, URI var2, int var3);

    protected abstract void addResponseHandlers(ChannelPipeline var1, Downstream<? super T> var2);

    protected void success(Downstream<? super T> downstream, T value) {
        if (this.fired.compareAndSet(false, true)) {
            downstream.success(value);
        }
    }

    protected void error(Downstream<?> downstream, Throwable error) {
        if (this.fired.compareAndSet(false, true)) {
            downstream.error(error);
        }
    }

    private static boolean isRedirect(int code) {
        return code == 301 || code == 302 || code == 303 || code == 307;
    }

    private static String getFullPath(URI uri) {
        StringBuilder sb = new StringBuilder(uri.getRawPath());
        String query = uri.getRawQuery();
        if (query != null) {
            sb.append("?").append(query);
        }
        return sb.toString();
    }
}

