/*
 * Decompiled with CFR 0.152.
 */
package ratpack.render;

import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.util.function.BiFunction;
import ratpack.exec.Promise;
import ratpack.func.Action;
import ratpack.handling.Context;
import ratpack.registry.RegistrySpec;

public interface RenderableDecorator<T> {
    public static <T> TypeToken<RenderableDecorator<T>> typeOf(Class<T> type) {
        return new TypeToken<RenderableDecorator<T>>(type){}.where(new TypeParameter<T>(){}, type);
    }

    public Class<T> getType();

    public Promise<T> decorate(Context var1, T var2);

    public static <T> RenderableDecorator<T> of(final Class<T> type, final BiFunction<? super Context, ? super T, ? extends T> impl) {
        return new RenderableDecorator<T>(){

            @Override
            public Class<T> getType() {
                return type;
            }

            @Override
            public Promise<T> decorate(Context context, T object) {
                return Promise.ofLazy(() -> impl.apply(context, object));
            }
        };
    }

    public static <T> RenderableDecorator<T> ofAsync(final Class<T> type, final BiFunction<? super Context, ? super T, ? extends Promise<T>> impl) {
        return new RenderableDecorator<T>(){

            @Override
            public Class<T> getType() {
                return type;
            }

            @Override
            public Promise<T> decorate(Context context, T object) {
                return (Promise)impl.apply(context, object);
            }
        };
    }

    default public Action<RegistrySpec> register() {
        return registrySpec -> registrySpec.add(RenderableDecorator.typeOf(this.getType()), this);
    }
}

