/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import java.nio.file.Path;
import java.time.Clock;
import ratpack.config.ConfigObject;
import ratpack.error.ClientErrorHandler;
import ratpack.error.ServerErrorHandler;
import ratpack.error.internal.DefaultDevelopmentErrorHandler;
import ratpack.error.internal.DefaultProductionErrorHandler;
import ratpack.error.internal.ErrorHandler;
import ratpack.exec.ExecController;
import ratpack.exec.ExecInitializer;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.internal.ExecControllerInternal;
import ratpack.file.FileSystemBinding;
import ratpack.file.MimeTypes;
import ratpack.file.internal.ActivationBackedMimeTypes;
import ratpack.file.internal.FileRenderer;
import ratpack.form.internal.FormParser;
import ratpack.func.Function;
import ratpack.handling.Redirector;
import ratpack.handling.RequestId;
import ratpack.handling.internal.DefaultRedirector;
import ratpack.handling.internal.UuidBasedRequestIdGenerator;
import ratpack.health.internal.HealthCheckResultsRenderer;
import ratpack.http.client.HttpClient;
import ratpack.jackson.JsonRender;
import ratpack.jackson.internal.JsonParser;
import ratpack.jackson.internal.JsonRenderer;
import ratpack.registry.Registry;
import ratpack.registry.RegistryBuilder;
import ratpack.registry.RegistrySpec;
import ratpack.render.Renderable;
import ratpack.render.Renderer;
import ratpack.render.internal.CharSequenceRenderer;
import ratpack.render.internal.PromiseRenderer;
import ratpack.render.internal.PublisherRenderer;
import ratpack.render.internal.RenderableRenderer;
import ratpack.server.PublicAddress;
import ratpack.server.RatpackServer;
import ratpack.server.ServerConfig;
import ratpack.server.StartupFailureException;
import ratpack.server.Stopper;
import ratpack.server.internal.InferringPublicAddress;
import ratpack.sse.ServerSentEventStreamClient;
import ratpack.util.Exceptions;

public abstract class ServerRegistry {
    public static Registry serverRegistry(RatpackServer ratpackServer, ExecControllerInternal execController, ServerConfig serverConfig, Function<? super Registry, ? extends Registry> userRegistryFactory) {
        Registry baseRegistry = ServerRegistry.buildBaseRegistry(ratpackServer, execController, serverConfig);
        Registry userRegistry = ServerRegistry.buildUserRegistry(userRegistryFactory, baseRegistry);
        execController.setInterceptors((ImmutableList<? extends ExecInterceptor>)ImmutableList.copyOf(userRegistry.getAll(ExecInterceptor.class)));
        execController.setInitializers((ImmutableList<? extends ExecInitializer>)ImmutableList.copyOf(userRegistry.getAll(ExecInitializer.class)));
        return baseRegistry.join(userRegistry);
    }

    private static Registry buildUserRegistry(Function<? super Registry, ? extends Registry> userRegistryFactory, Registry baseRegistry) {
        Registry userRegistry;
        try {
            userRegistry = userRegistryFactory.apply(baseRegistry);
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e);
            throw new StartupFailureException("Failed to build user registry", e);
        }
        return userRegistry;
    }

    public static Registry buildBaseRegistry(RatpackServer ratpackServer, ExecController execController, ServerConfig serverConfig) {
        RegistrySpec baseRegistryBuilder;
        ErrorHandler errorHandler = serverConfig.isDevelopment() ? new DefaultDevelopmentErrorHandler() : new DefaultProductionErrorHandler();
        try {
            PromiseRenderer promiseRenderer = new PromiseRenderer();
            PublisherRenderer publisherRenderer = new PublisherRenderer();
            baseRegistryBuilder = Registry.builder().add(ServerConfig.class, (Object)serverConfig).add(ByteBufAllocator.class, PooledByteBufAllocator.DEFAULT).add(ExecController.class, execController).add(MimeTypes.class, new ActivationBackedMimeTypes()).add(PublicAddress.class, serverConfig.getPublicAddress() == null ? new InferringPublicAddress(serverConfig.getSslContext() == null ? "http" : "https") : PublicAddress.of(serverConfig.getPublicAddress())).add(Redirector.class, new DefaultRedirector()).add(ClientErrorHandler.class, errorHandler).add(ServerErrorHandler.class, errorHandler).add((TypeToken)Renderer.typeOf(Path.class), new FileRenderer()).add(Renderer.typeOf(promiseRenderer.getType()), promiseRenderer).add(Renderer.typeOf(publisherRenderer.getType()), publisherRenderer).add((TypeToken)Renderer.typeOf(Renderable.class), new RenderableRenderer()).add((TypeToken)Renderer.typeOf(CharSequence.class), new CharSequenceRenderer()).add((TypeToken)Renderer.typeOf(JsonRender.class), new JsonRenderer()).add(FormParser.class, new FormParser()).add(Clock.class, Clock.systemDefaultZone()).add(JsonParser.class, new JsonParser()).add(RatpackServer.class, ratpackServer).add(ObjectMapper.class, new ObjectMapper()).add(Stopper.class, () -> Exceptions.uncheck(() -> {
                ratpackServer.stop();
                return null;
            })).add(HttpClient.class, HttpClient.httpClient((ByteBufAllocator)PooledByteBufAllocator.DEFAULT, serverConfig.getMaxContentLength())).add(ServerSentEventStreamClient.class, ServerSentEventStreamClient.sseStreamClient((ByteBufAllocator)PooledByteBufAllocator.DEFAULT)).add(HealthCheckResultsRenderer.class, new HealthCheckResultsRenderer()).add(RequestId.Generator.class, new UuidBasedRequestIdGenerator());
            ServerRegistry.addConfigObjects(serverConfig, (RegistryBuilder)baseRegistryBuilder);
        }
        catch (Exception e) {
            throw Exceptions.uncheck(e);
        }
        if (serverConfig.isHasBaseDir()) {
            baseRegistryBuilder.add(FileSystemBinding.class, serverConfig.getBaseDir());
        }
        return baseRegistryBuilder.build();
    }

    private static void addConfigObjects(ServerConfig serverConfig, RegistryBuilder baseRegistryBuilder) {
        for (ConfigObject configObject : serverConfig.getRequiredConfig()) {
            ServerRegistry.addConfigObject(baseRegistryBuilder, configObject);
        }
    }

    private static <T> void addConfigObject(RegistryBuilder baseRegistryBuilder, ConfigObject<T> configObject) {
        baseRegistryBuilder.add(configObject.getType(), (Object)configObject.getObject());
    }
}

