/*
 * Decompiled with CFR 0.152.
 */
package ratpack.file.internal;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import ratpack.exec.Blocking;
import ratpack.file.MimeTypes;
import ratpack.func.Action;
import ratpack.func.Factory;
import ratpack.handling.Context;
import ratpack.http.Response;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.render.RendererSupport;
import ratpack.server.internal.ServerEnvironment;
import ratpack.util.Exceptions;
import ratpack.util.internal.BoundedConcurrentHashMap;

public class FileRenderer
extends RendererSupport<Path> {
    private static final boolean CACHEABLE = !ServerEnvironment.env().isDevelopment();
    private static final ConcurrentMap<Path, Optional<BasicFileAttributes>> CACHE = new BoundedConcurrentHashMap<Path, Optional<BasicFileAttributes>>(10000, Runtime.getRuntime().availableProcessors());

    @Override
    public void render(Context context, Path targetFile) throws Exception {
        FileRenderer.readAttributes(targetFile, attributes -> {
            if (attributes == null || !attributes.isRegularFile()) {
                context.clientError(404);
            } else {
                FileRenderer.sendFile(context, targetFile, attributes);
            }
        });
    }

    public static void sendFile(Context context, Path file, BasicFileAttributes attributes) {
        if (!context.getRequest().getMethod().isGet()) {
            context.clientError(405);
            return;
        }
        Date date = new Date(attributes.lastModifiedTime().toMillis());
        context.lastModified(date, () -> {
            String ifNoneMatch = context.getRequest().getHeaders().get((CharSequence)HttpHeaderNames.IF_NONE_MATCH);
            Response response = context.getResponse();
            if (ifNoneMatch != null && ifNoneMatch.trim().equals("*")) {
                response.status(HttpResponseStatus.NOT_MODIFIED.code()).send();
                return;
            }
            response.contentTypeIfNotSet(() -> context.get(MimeTypes.class).getContentType(file.getFileName().toString()));
            response.getHeaders().set(HttpHeaderConstants.CONTENT_LENGTH, Long.toString(attributes.size()));
            try {
                response.sendFile(file);
            }
            catch (Exception e) {
                throw Exceptions.uncheck(e);
            }
        });
    }

    private static Factory<BasicFileAttributes> getter(Path file) {
        return () -> {
            if (Files.exists(file, new LinkOption[0])) {
                return Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
            }
            return null;
        };
    }

    public static void readAttributes(Path file, Action<? super BasicFileAttributes> then) throws Exception {
        if (CACHEABLE) {
            Optional basicFileAttributes = (Optional)CACHE.get(file);
            if (basicFileAttributes == null) {
                Blocking.get(FileRenderer.getter(file)).then(a -> {
                    CACHE.put(file, Optional.ofNullable(a));
                    then.execute((BasicFileAttributes)a);
                });
            } else {
                then.execute(basicFileAttributes.orElse(null));
            }
        } else {
            Blocking.get(FileRenderer.getter(file)).then(then);
        }
    }
}

