/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import ratpack.file.FileSystemBinding;
import ratpack.server.ServerConfig;

public class ServerConfigData {
    private final FileSystemBinding baseDir;
    private int port;
    private InetAddress address;
    private boolean development;
    private int threads = ServerConfig.DEFAULT_THREADS;
    private URI publicAddress;
    private SSLContext sslContext;
    private boolean requireClientSslAuth;
    private int maxContentLength = 0x100000;
    private Optional<Integer> connectTimeoutMillis = Optional.empty();
    private Optional<Integer> maxMessagesPerRead = Optional.empty();
    private Optional<Integer> receiveBufferSize = Optional.empty();
    private Optional<Integer> writeSpinCount = Optional.empty();

    public ServerConfigData(FileSystemBinding baseDir, int port, boolean development, URI publicAddress) {
        this.baseDir = baseDir;
        this.port = port;
        this.development = development;
        this.publicAddress = publicAddress;
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public boolean isDevelopment() {
        return this.development;
    }

    public int getThreads() {
        return this.threads;
    }

    public URI getPublicAddress() {
        return this.publicAddress;
    }

    public int getMaxContentLength() {
        return this.maxContentLength;
    }

    public Optional<Integer> getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public Optional<Integer> getMaxMessagesPerRead() {
        return this.maxMessagesPerRead;
    }

    public Optional<Integer> getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public Optional<Integer> getWriteSpinCount() {
        return this.writeSpinCount;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public void setAddress(String host) throws UnknownHostException {
        this.setAddress(InetAddress.getByName(host));
    }

    public void setDevelopment(boolean development) {
        this.development = development;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public void setPublicAddress(URI publicAddress) {
        this.publicAddress = publicAddress;
    }

    public void setPublicAddress(String publicAddress) throws URISyntaxException {
        this.publicAddress = new URI(publicAddress);
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public boolean isRequireClientSslAuth() {
        return this.requireClientSslAuth;
    }

    public void setRequireClientSslAuth(boolean requireClientSslAuth) {
        this.requireClientSslAuth = requireClientSslAuth;
    }

    public void setMaxContentLength(int maxContentLength) {
        this.maxContentLength = maxContentLength;
    }

    public void setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.connectTimeoutMillis = Optional.of(connectTimeoutMillis);
    }

    public void setMaxMessagesPerRead(int maxMessagesPerRead) {
        this.maxMessagesPerRead = Optional.of(maxMessagesPerRead);
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = Optional.of(receiveBufferSize);
    }

    public void setWriteSpinCount(int writeSpinCount) {
        this.writeSpinCount = Optional.of(writeSpinCount);
    }

    public FileSystemBinding getBaseDir() {
        return this.baseDir;
    }
}

