/*
 * Decompiled with CFR 0.152.
 */
package ratpack.stream.internal;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

abstract class SubscriptionSupport<T>
implements Subscription {
    private Subscriber<? super T> subscriber;
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean stopped = new AtomicBoolean();
    private final AtomicLong waitingRequests = new AtomicLong(Long.MIN_VALUE);
    private final AtomicBoolean drainingRequests = new AtomicBoolean();
    private final AtomicBoolean complete = new AtomicBoolean();
    private final AtomicReference<Throwable> error = new AtomicReference();
    private final AtomicBoolean inOnMethod = new AtomicBoolean();
    private final ConcurrentLinkedQueue<T> onNextQueue = new ConcurrentLinkedQueue();

    protected SubscriptionSupport(Subscriber<? super T> subscriber) {
        this.subscriber = subscriber;
        subscriber.onSubscribe((Subscription)this);
    }

    public final void request(long n) {
        if (n < 1L) {
            this.onError(new IllegalArgumentException("3.9 While the Subscription is not cancelled, Subscription.request(long n) MUST throw a java.lang.IllegalArgumentException if the argument is <= 0."));
            this.cancel();
        }
        if (!this.stopped.get()) {
            long waiting = this.waitingRequests.get();
            if (waiting < 0L) {
                this.waitingRequests.addAndGet(n);
            }
            if (this.started.get()) {
                this.drainRequests();
            }
        }
    }

    protected boolean isStopped() {
        return this.stopped.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainRequests() {
        if (this.drainingRequests.compareAndSet(false, true)) {
            try {
                long n = this.waitingRequests.getAndSet(Long.MIN_VALUE);
                if (n == Long.MAX_VALUE) {
                    return;
                }
                while (!this.stopped.get() && n > Long.MIN_VALUE) {
                    if (n >= 0L) {
                        this.doRequest(Long.MAX_VALUE);
                        this.waitingRequests.set(Long.MAX_VALUE);
                        return;
                    }
                    long r = n + Long.MIN_VALUE;
                    this.doRequest(r);
                    n = this.waitingRequests.getAndSet(Long.MIN_VALUE);
                }
            }
            finally {
                this.drainingRequests.set(false);
            }
            if (this.waitingRequests.get() > Long.MIN_VALUE) {
                this.drainRequests();
            }
        }
    }

    protected abstract void doRequest(long var1);

    public final void cancel() {
        this.stopped.set(true);
        this.subscriber = null;
        this.doCancel();
    }

    protected void doCancel() {
    }

    protected void start() {
        if (this.started.compareAndSet(false, true)) {
            this.drainRequests();
        }
    }

    private void drain() {
        if (this.inOnMethod.compareAndSet(false, true)) {
            try {
                while (true) {
                    Throwable error;
                    if ((error = this.error.get()) != null) {
                        this.subscriber.onError(error);
                        return;
                    }
                    T next = this.onNextQueue.poll();
                    if (next == null) break;
                    this.subscriber.onNext(next);
                }
                if (this.complete.get()) {
                    this.subscriber.onComplete();
                    return;
                }
            }
            finally {
                this.inOnMethod.set(false);
            }
            if (!this.onNextQueue.isEmpty() || this.complete.get() || this.error.get() != null) {
                this.drain();
            }
        }
    }

    public void onNext(T t) {
        if (!this.stopped.get()) {
            this.onNextQueue.add(t);
            this.drain();
        }
    }

    public void onError(Throwable t) {
        if (this.stopped.compareAndSet(false, true)) {
            this.error.set(t);
            this.drain();
        }
    }

    public void onComplete() {
        if (this.stopped.compareAndSet(false, true)) {
            this.complete.set(true);
            this.drain();
        }
    }
}

