/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedNioStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import ratpack.exec.Blocking;
import ratpack.server.internal.ResponseWriter;
import ratpack.server.internal.ResponseWritingListener;

class ChunkedFileResponseWriter
implements ResponseWriter {
    private final Path file;

    ChunkedFileResponseWriter(Path file) {
        this.file = file;
    }

    @Override
    public void write(Channel channel, Consumer<? super ResponseWritingListener> listenerReceiver, Consumer<? super ChannelFuture> then) {
        Blocking.get(() -> Files.newByteChannel(this.file, new OpenOption[0])).then(fileChannel -> then.accept(channel.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new ChunkedNioStream((ReadableByteChannel)fileChannel)))));
    }
}

