/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.api.Nullable;
import ratpack.exec.Promise;
import ratpack.func.Action;
import ratpack.handling.RequestOutcome;
import ratpack.handling.internal.DefaultRequestOutcome;
import ratpack.handling.internal.DoubleTransmissionException;
import ratpack.http.Request;
import ratpack.http.internal.ConnectionIdleTimeout;
import ratpack.http.internal.CustomHttpResponse;
import ratpack.http.internal.DefaultSentResponse;
import ratpack.http.internal.DefaultStatus;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.http.internal.NettyHeadersBackedHeaders;
import ratpack.server.internal.ChunkedFileResponseWriter;
import ratpack.server.internal.LastHttpContentResponseWriter;
import ratpack.server.internal.RequestBody;
import ratpack.server.internal.ResponseTransmitter;
import ratpack.server.internal.ResponseWriter;
import ratpack.server.internal.ResponseWritingListener;
import ratpack.server.internal.StreamingResponseWriter;
import ratpack.server.internal.ZeroCopyFileResponseWriter;

public class DefaultResponseTransmitter
implements ResponseTransmitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseTransmitter.class);
    private static final LastHttpContentResponseWriter EMPTY_BODY = new LastHttpContentResponseWriter(LastHttpContent.EMPTY_LAST_CONTENT);
    private static final DefaultHttpHeaders ERROR_RESPONSE_HEADERS = new DefaultHttpHeaders();
    private final AtomicBoolean transmitted;
    private final Channel channel;
    private final Clock clock;
    private final Request ratpackRequest;
    private final HttpHeaders responseHeaders;
    private final RequestBody requestBody;
    private final boolean isSsl;
    private final HttpRequest nettyRequest;
    private List<Action<? super RequestOutcome>> outcomeListeners;
    private Instant stopTime;
    private ResponseWritingListener writingListener;
    private boolean done;

    public DefaultResponseTransmitter(AtomicBoolean transmitted, Channel channel, Clock clock, HttpRequest nettyRequest, Request ratpackRequest, HttpHeaders responseHeaders, @Nullable RequestBody requestBody) {
        this.transmitted = transmitted;
        this.channel = channel;
        this.clock = clock;
        this.ratpackRequest = ratpackRequest;
        this.responseHeaders = responseHeaders;
        this.requestBody = requestBody;
        this.nettyRequest = nettyRequest;
        this.isSsl = channel.pipeline().get(SslHandler.class) != null;
    }

    private void sendResponse(HttpResponseStatus responseStatus, ResponseWriter bodyWriter) {
        if (this.transmitted.compareAndSet(false, true)) {
            this.stopTime = this.clock.instant();
            if (this.requestBody == null) {
                this.sendResponseAfterRequestBodyDrain(responseStatus, bodyWriter);
            } else {
                this.requestBody.drain().onError(e -> {
                    LOGGER.warn("An error occurred draining the unread request body. The connection will be closed", e);
                    this.forceCloseWithResponse(HttpResponseStatus.INTERNAL_SERVER_ERROR);
                }).then(outcome -> {
                    switch (outcome) {
                        case TOO_LARGE: {
                            bodyWriter.dispose();
                            this.forceCloseWithResponse(HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE);
                            break;
                        }
                        case DISCARDED: {
                            this.addConnectionCloseResponseHeader();
                            this.sendResponseAfterRequestBodyDrain(responseStatus, bodyWriter);
                            break;
                        }
                        case DRAINED: {
                            this.sendResponseAfterRequestBodyDrain(responseStatus, bodyWriter);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("unhandled drain outcome: " + (Object)outcome);
                        }
                    }
                });
            }
        } else {
            bodyWriter.dispose();
            if (this.done) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("", (Throwable)new DoubleTransmissionException("Attempt at double transmission after response sent for: " + this.ratpackRequest.getRawUri()));
                }
            } else {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("", (Throwable)new DoubleTransmissionException("Attempt at double transmission while sending response (connection will be closed) for: " + this.ratpackRequest.getRawUri()));
                }
                this.channel.close();
            }
        }
    }

    private void sendResponseAfterRequestBodyDrain(HttpResponseStatus responseStatus, ResponseWriter bodyWriter) {
        try {
            boolean keepAlive;
            boolean responseRequestedConnectionClose = this.responseHeaders.contains((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.CLOSE, true);
            boolean requestRequestedConnectionClose = !HttpUtil.isKeepAlive((HttpMessage)this.nettyRequest);
            boolean bl = keepAlive = !requestRequestedConnectionClose && !responseRequestedConnectionClose;
            if (!keepAlive && !responseRequestedConnectionClose) {
                this.addConnectionCloseResponseHeader();
            }
            CustomHttpResponse headersResponse = new CustomHttpResponse(responseStatus, this.responseHeaders);
            if (this.mustHaveBody(responseStatus) && keepAlive && HttpUtil.getContentLength((HttpMessage)headersResponse, (int)-1) == -1 && !HttpUtil.isTransferEncodingChunked((HttpMessage)headersResponse)) {
                HttpUtil.setTransferEncodingChunked((HttpMessage)headersResponse, (boolean)true);
            }
            Promise.async(down -> this.channel.writeAndFlush((Object)headersResponse).addListener(future -> down.success((Object)future.isSuccess()))).then(success -> {
                if (success.booleanValue()) {
                    bodyWriter.write(this.channel, writingListener -> {
                        this.writingListener = writingListener;
                    }, future -> {
                        this.writingListener = null;
                        future.addListener(result -> {
                            if (result.isSuccess()) {
                                if (this.channel.isOpen() && keepAlive) {
                                    this.channel.read();
                                    ConnectionIdleTimeout.of(this.channel).reset();
                                } else {
                                    this.channel.close();
                                }
                                this.notifyListeners(responseStatus);
                            } else {
                                LOGGER.warn("Error from response body writer", result.cause());
                                this.channel.close();
                            }
                        });
                    });
                } else {
                    bodyWriter.dispose();
                    this.notifyListeners(responseStatus);
                }
            });
        }
        catch (Exception e) {
            bodyWriter.dispose();
            LOGGER.warn("Error finalizing response", (Throwable)e);
            this.forceCloseWithResponse(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private void forceCloseWithResponse(HttpResponseStatus status) {
        Promise.async(down -> this.channel.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.EMPTY_BUFFER, (HttpHeaders)ERROR_RESPONSE_HEADERS, (HttpHeaders)EmptyHttpHeaders.INSTANCE)).addListener(future -> down.success((Object)future.isSuccess()))).onError(__ -> {
            this.channel.close();
            this.notifyListeners(status);
        }).then(__ -> {
            this.channel.close();
            this.notifyListeners(status);
        });
    }

    private boolean mustHaveBody(HttpResponseStatus responseStatus) {
        int code = responseStatus.code();
        return (code < 100 || code >= 200) && code != 204 && code != 304;
    }

    @Override
    public void transmit(HttpResponseStatus responseStatus, ByteBuf body) {
        if (body.readableBytes() == 0) {
            body.release();
            this.sendResponse(responseStatus, EMPTY_BODY);
        } else {
            this.sendResponse(responseStatus, new LastHttpContentResponseWriter((LastHttpContent)new DefaultLastHttpContent(body.touch())));
        }
    }

    private boolean isHead() {
        return this.ratpackRequest.getMethod().isHead();
    }

    @Override
    public void transmit(HttpResponseStatus status, Path file) {
        if (this.isHead()) {
            this.sendResponse(status, EMPTY_BODY);
        } else {
            String sizeString = this.responseHeaders.getAsString(HttpHeaderConstants.CONTENT_LENGTH);
            long size = sizeString == null ? 0L : Long.parseLong(sizeString);
            boolean compress = !this.responseHeaders.contains(HttpHeaderConstants.CONTENT_ENCODING, HttpHeaderConstants.IDENTITY, true);
            boolean zeroCopy = !this.isSsl && !compress && file.getFileSystem().equals(FileSystems.getDefault());
            ResponseWriter responseWriter = zeroCopy ? new ZeroCopyFileResponseWriter(file, size) : new ChunkedFileResponseWriter(file);
            this.sendResponse(status, responseWriter);
        }
    }

    @Override
    public void transmit(HttpResponseStatus status, Publisher<? extends ByteBuf> publisher) {
        this.sendResponse(status, new StreamingResponseWriter(publisher));
    }

    private void notifyListeners(HttpResponseStatus responseStatus) {
        this.done = true;
        if (this.outcomeListeners != null) {
            DefaultSentResponse sentResponse = new DefaultSentResponse(new NettyHeadersBackedHeaders(this.responseHeaders), new DefaultStatus(responseStatus));
            DefaultRequestOutcome requestOutcome = new DefaultRequestOutcome(this.ratpackRequest, sentResponse, this.stopTime);
            for (Action<? super RequestOutcome> outcomeListener : this.outcomeListeners) {
                try {
                    outcomeListener.execute((Object)requestOutcome);
                }
                catch (Exception e) {
                    LOGGER.warn("request outcome listener " + outcomeListener + " threw exception", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void onWritabilityChanged() {
        if (this.writingListener != null && this.channel.isWritable()) {
            this.writingListener.onWritable();
        }
    }

    @Override
    public void onConnectionClosed() {
        if (this.writingListener != null) {
            this.writingListener.onClosed();
        }
    }

    @Override
    public void addOutcomeListener(Action<? super RequestOutcome> action) {
        if (this.outcomeListeners == null) {
            this.outcomeListeners = new ArrayList<Action<? super RequestOutcome>>(1);
        }
        this.outcomeListeners.add(action);
    }

    void addConnectionCloseResponseHeader() {
        this.responseHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
    }

    static {
        ERROR_RESPONSE_HEADERS.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        ERROR_RESPONSE_HEADERS.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
    }
}

