/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.ByteSource;
import com.google.common.reflect.TypeToken;
import io.netty.handler.ssl.SslContext;
import java.io.File;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import ratpack.config.ConfigDataBuilder;
import ratpack.config.ConfigSource;
import ratpack.config.EnvironmentParser;
import ratpack.exec.ExecController;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.server.BaseDir;
import ratpack.server.ServerConfig;
import ratpack.util.Types;

public interface ServerConfigBuilder
extends ConfigDataBuilder {
    public ServerConfigBuilder baseDir(Path var1);

    default public ServerConfigBuilder baseDir(File file) {
        return this.baseDir(file.toPath());
    }

    default public ServerConfigBuilder findBaseDir() {
        return this.baseDir(BaseDir.find());
    }

    default public ServerConfigBuilder findBaseDir(String markerFilePath) {
        return this.baseDir(BaseDir.find(markerFilePath));
    }

    public ServerConfigBuilder inheritExecController(boolean var1);

    public ServerConfigBuilder execController(ExecController var1);

    public ServerConfigBuilder port(int var1);

    public ServerConfigBuilder address(InetAddress var1);

    public ServerConfigBuilder development(boolean var1);

    public ServerConfigBuilder threads(int var1);

    public ServerConfigBuilder registerShutdownHook(boolean var1);

    public ServerConfigBuilder publicAddress(URI var1);

    public ServerConfigBuilder maxContentLength(int var1);

    public ServerConfigBuilder maxChunkSize(int var1);

    public ServerConfigBuilder maxInitialLineLength(int var1);

    public ServerConfigBuilder maxHeaderSize(int var1);

    public ServerConfigBuilder connectTimeoutMillis(int var1);

    public ServerConfigBuilder idleTimeout(Duration var1);

    public ServerConfigBuilder maxMessagesPerRead(int var1);

    public ServerConfigBuilder receiveBufferSize(int var1);

    public ServerConfigBuilder connectQueueSize(int var1);

    public ServerConfigBuilder writeSpinCount(int var1);

    public ServerConfigBuilder portFile(Path var1);

    @Deprecated
    public ServerConfigBuilder ssl(SSLContext var1);

    @Deprecated
    public ServerConfigBuilder requireClientSslAuth(boolean var1);

    public ServerConfigBuilder ssl(SslContext var1);

    @Override
    public ServerConfigBuilder env();

    @Override
    public ServerConfigBuilder env(String var1);

    @Override
    public ServerConfigBuilder args(String[] var1);

    @Override
    public ServerConfigBuilder args(String var1, String[] var2);

    @Override
    public ServerConfigBuilder args(String var1, String var2, String[] var3);

    @Override
    public ServerConfigBuilder props(ByteSource var1);

    @Override
    public ServerConfigBuilder props(String var1);

    @Override
    public ServerConfigBuilder props(Path var1);

    @Override
    public ServerConfigBuilder props(Properties var1);

    @Override
    public ServerConfigBuilder object(String var1, Object var2);

    @Override
    public ServerConfigBuilder props(Map<String, String> var1);

    @Override
    public ServerConfigBuilder props(URL var1);

    @Override
    public ServerConfigBuilder sysProps();

    @Override
    public ServerConfigBuilder sysProps(String var1);

    @Override
    public ServerConfigBuilder onError(Action<? super Throwable> var1);

    @Override
    public ServerConfigBuilder configureObjectMapper(Action<ObjectMapper> var1);

    @Override
    public ServerConfigBuilder add(ConfigSource var1);

    @Override
    public ServerConfigBuilder env(String var1, Function<String, String> var2);

    @Override
    public ServerConfigBuilder env(EnvironmentParser var1);

    @Override
    public ServerConfigBuilder json(ByteSource var1);

    @Override
    public ServerConfigBuilder json(Path var1);

    @Override
    public ServerConfigBuilder json(String var1);

    @Override
    public ServerConfigBuilder json(URL var1);

    @Override
    public ServerConfigBuilder yaml(ByteSource var1);

    @Override
    public ServerConfigBuilder yaml(Path var1);

    @Override
    public ServerConfigBuilder yaml(String var1);

    @Override
    public ServerConfigBuilder yaml(URL var1);

    default public ServerConfigBuilder require(String pointer, Class<?> type) {
        return this.require(pointer, Types.token(type));
    }

    default public ServerConfigBuilder require(String pointer, Type type) {
        return this.require(pointer, Types.token((Type)type));
    }

    public ServerConfigBuilder require(String var1, TypeToken<?> var2);

    @Override
    public ServerConfig build();
}

