/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import io.netty.buffer.ByteBufAllocator;
import java.time.Clock;
import java.util.Optional;
import ratpack.config.ConfigObject;
import ratpack.error.ClientErrorHandler;
import ratpack.error.ServerErrorHandler;
import ratpack.error.internal.DefaultDevelopmentErrorHandler;
import ratpack.error.internal.DefaultProductionErrorHandler;
import ratpack.error.internal.ErrorHandler;
import ratpack.exec.ExecController;
import ratpack.file.FileSystemBinding;
import ratpack.file.MimeTypes;
import ratpack.file.internal.ActivationBackedMimeTypes;
import ratpack.file.internal.FileRenderer;
import ratpack.form.internal.FormParser;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.handling.Redirector;
import ratpack.handling.RequestId;
import ratpack.handling.internal.UuidBasedRequestIdGenerator;
import ratpack.health.internal.HealthCheckResultsRenderer;
import ratpack.http.client.HttpClient;
import ratpack.http.client.HttpClientSpec;
import ratpack.impose.Impositions;
import ratpack.jackson.internal.JsonParser;
import ratpack.jackson.internal.JsonRenderer;
import ratpack.registry.Registry;
import ratpack.registry.RegistryBuilder;
import ratpack.render.internal.CharSequenceRenderer;
import ratpack.render.internal.OptionalRenderer;
import ratpack.render.internal.PromiseRenderer;
import ratpack.render.internal.PublisherRenderer;
import ratpack.render.internal.RenderableRenderer;
import ratpack.server.PublicAddress;
import ratpack.server.RatpackServer;
import ratpack.server.ServerConfig;
import ratpack.server.StartupFailureException;
import ratpack.server.Stopper;
import ratpack.sse.ServerSentEventStreamClient;
import ratpack.sse.client.ServerSentEventClient;
import ratpack.util.Exceptions;

public abstract class ServerRegistry {
    public static Registry serverRegistry(RatpackServer ratpackServer, Impositions impositions, ExecController execController, ServerConfig serverConfig, Function<? super Registry, ? extends Registry> userRegistryFactory) {
        Registry baseRegistry = ServerRegistry.buildBaseRegistry(ratpackServer, impositions, execController, serverConfig);
        Registry userRegistry = ServerRegistry.buildUserRegistry(impositions, userRegistryFactory, baseRegistry);
        return baseRegistry.join(userRegistry);
    }

    private static Registry buildUserRegistry(Impositions impositions, Function<? super Registry, ? extends Registry> userRegistryFactory, Registry baseRegistry) {
        Registry userRegistry;
        try {
            userRegistry = (Registry)impositions.imposeOver(() -> (Registry)userRegistryFactory.apply((Object)baseRegistry));
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new StartupFailureException("Failed to build user registry", e);
        }
        return userRegistry;
    }

    public static Registry buildBaseRegistry(RatpackServer ratpackServer, Impositions impositions, ExecController execController, ServerConfig serverConfig) {
        RegistryBuilder baseRegistryBuilder;
        ErrorHandler errorHandler = serverConfig.isDevelopment() ? new DefaultDevelopmentErrorHandler() : new DefaultProductionErrorHandler();
        try {
            HttpClient httpClient = HttpClient.of((Action<? super HttpClientSpec>)((Action)s -> s.poolSize(0).byteBufAllocator(ByteBufAllocator.DEFAULT).maxContentLength(serverConfig.getMaxContentLength()).execController(execController)));
            baseRegistryBuilder = Registry.builder().add(ServerConfig.class, (Object)serverConfig).add(Impositions.class, (Object)impositions).add(ByteBufAllocator.class, (Object)ByteBufAllocator.DEFAULT).add(ExecController.class, (Object)execController).add(MimeTypes.class, (Object)ActivationBackedMimeTypes.INSTANCE).add(PublicAddress.class, (Object)Optional.ofNullable(serverConfig.getPublicAddress()).map(PublicAddress::of).orElseGet(() -> PublicAddress.bindAddress(ratpackServer))).add(Redirector.TYPE, (Object)Redirector.standard()).add(ClientErrorHandler.class, (Object)errorHandler).add(ServerErrorHandler.class, (Object)errorHandler).add(FileRenderer.TYPE, serverConfig.isDevelopment() ? FileRenderer.NON_CACHING : FileRenderer.CACHING).add(PromiseRenderer.TYPE, PromiseRenderer.INSTANCE).add(PublisherRenderer.TYPE, PublisherRenderer.INSTANCE).add(OptionalRenderer.TYPE, OptionalRenderer.INSTANCE).add(RenderableRenderer.TYPE, RenderableRenderer.INSTANCE).add(CharSequenceRenderer.TYPE, CharSequenceRenderer.INSTANCE).add(JsonRenderer.TYPE, JsonRenderer.INSTANCE).add(FormParser.TYPE, FormParser.INSTANCE).add(JsonParser.TYPE, JsonParser.INSTANCE).add(Clock.class, (Object)Clock.systemDefaultZone()).add(RatpackServer.class, (Object)ratpackServer).add(ObjectMapper.class, (Object)new ObjectMapper()).add(Stopper.class, () -> Exceptions.uncheck(() -> {
                ratpackServer.stop();
                return null;
            })).add(HttpClient.class, (Object)httpClient).add(ServerSentEventClient.class, (Object)ServerSentEventClient.of(httpClient)).add(ServerSentEventStreamClient.class, (Object)ServerSentEventStreamClient.of(httpClient)).add(HealthCheckResultsRenderer.TYPE, (Object)new HealthCheckResultsRenderer(ByteBufAllocator.DEFAULT)).add(RequestId.Generator.class, (Object)UuidBasedRequestIdGenerator.INSTANCE);
            ServerRegistry.addConfigObjects(serverConfig, baseRegistryBuilder);
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Throwable)e);
        }
        if (serverConfig.isHasBaseDir()) {
            baseRegistryBuilder.add(FileSystemBinding.class, (Object)serverConfig.getBaseDir());
        }
        return baseRegistryBuilder.build();
    }

    private static void addConfigObjects(ServerConfig serverConfig, RegistryBuilder baseRegistryBuilder) {
        for (ConfigObject configObject : serverConfig.getRequiredConfig()) {
            ServerRegistry.addConfigObject(baseRegistryBuilder, configObject);
        }
    }

    private static <T> void addConfigObject(RegistryBuilder baseRegistryBuilder, ConfigObject<T> configObject) {
        baseRegistryBuilder.add(configObject.getTypeToken(), configObject.getObject());
    }
}

