/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import ratpack.http.client.internal.HttpChannelKey;
import ratpack.http.client.internal.IdleTimeoutHandler;
import ratpack.http.client.internal.IdlingConnectionHandler;
import ratpack.http.client.internal.InstrumentedChannelPoolHandler;
import ratpack.http.client.internal.ProxyChannelPoolHandler;

public class NoopFixedChannelPoolHandler
extends ProxyChannelPoolHandler
implements InstrumentedChannelPoolHandler {
    private static final String IDLE_STATE_HANDLER_NAME = "idleState";
    private final String host;
    private final Duration idleTimeout;

    public NoopFixedChannelPoolHandler(HttpChannelKey channelKey, Duration idleTimeout) {
        super(channelKey);
        this.host = channelKey.host;
        this.idleTimeout = idleTimeout;
    }

    public void channelReleased(Channel ch) throws Exception {
        if (ch.isOpen()) {
            ch.config().setAutoRead(true);
            ch.pipeline().addLast(new ChannelHandler[]{IdlingConnectionHandler.INSTANCE});
            if (this.idleTimeout.toNanos() > 0L) {
                ch.pipeline().addLast(IDLE_STATE_HANDLER_NAME, (ChannelHandler)new IdleStateHandler(this.idleTimeout.toNanos(), this.idleTimeout.toNanos(), 0L, TimeUnit.NANOSECONDS));
                ch.pipeline().addLast(new ChannelHandler[]{IdleTimeoutHandler.INSTANCE});
            }
        }
    }

    public void channelAcquired(Channel ch) throws Exception {
        if (ch.pipeline().context((ChannelHandler)IdlingConnectionHandler.INSTANCE) != null) {
            ch.pipeline().remove((ChannelHandler)IdlingConnectionHandler.INSTANCE);
        }
        if (ch.pipeline().context(IDLE_STATE_HANDLER_NAME) != null) {
            ch.pipeline().remove(IDLE_STATE_HANDLER_NAME);
        }
        if (ch.pipeline().context((ChannelHandler)IdleTimeoutHandler.INSTANCE) != null) {
            ch.pipeline().remove((ChannelHandler)IdleTimeoutHandler.INSTANCE);
        }
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getActiveConnectionCount() {
        return 0;
    }

    @Override
    public int getIdleConnectionCount() {
        return 0;
    }
}

