/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import io.netty.handler.ssl.SslContext;
import java.net.InetAddress;
import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import ratpack.api.Nullable;
import ratpack.config.ConfigData;
import ratpack.config.ConfigObject;
import ratpack.exec.ExecController;
import ratpack.file.FileSystemBinding;
import ratpack.func.Action;
import ratpack.impose.Impositions;
import ratpack.server.NoBaseDirException;
import ratpack.server.ServerConfigBuilder;
import ratpack.server.internal.DefaultServerConfigBuilder;
import ratpack.server.internal.ServerEnvironment;
import ratpack.util.Types;

public interface ServerConfig
extends ConfigData {
    public static final TypeToken<ServerConfig> TYPE = Types.token(ServerConfig.class);
    public static final int DEFAULT_PORT = 5050;
    public static final int DEFAULT_MAX_CONTENT_LENGTH = 0x100000;
    public static final int DEFAULT_THREADS = Runtime.getRuntime().availableProcessors() * 2;
    public static final int DEFAULT_CORE_BLOCKING_THREADS = Runtime.getRuntime().availableProcessors() * 2;
    public static final Duration DEFAULT_BLOCKING_THREAD_IDLE_TIMEOUT = Duration.ofSeconds(60L);
    public static final int DEFAULT_MAX_CHUNK_SIZE = 8192;
    public static final int DEFAULT_MAX_INITIAL_LINE_LENGTH = 4096;
    public static final int DEFAULT_MAX_HEADER_SIZE = 8192;

    public static ServerConfigBuilder embedded() {
        return ServerConfig.builder().development(true).port(0);
    }

    public static ServerConfigBuilder builder() {
        return new DefaultServerConfigBuilder(ServerEnvironment.env(), Impositions.current());
    }

    public static ServerConfig of(Action<? super ServerConfigBuilder> action) throws Exception {
        return ((ServerConfigBuilder)action.with((Object)ServerConfig.builder())).build();
    }

    public int getPort();

    public Optional<ExecController> getInheritedExecController();

    public Optional<Path> getPortFile();

    @Nullable
    public InetAddress getAddress();

    public ImmutableSet<ConfigObject<?>> getRequiredConfig();

    public boolean isDevelopment();

    public int getThreads();

    public boolean isRegisterShutdownHook();

    public URI getPublicAddress();

    @Nullable
    @Deprecated
    public SSLContext getSslContext();

    public SslContext getNettySslContext();

    @Deprecated
    public boolean isRequireClientSslAuth();

    public int getMaxContentLength();

    public Optional<Integer> getConnectTimeoutMillis();

    public Optional<Integer> getMaxMessagesPerRead();

    public Optional<Integer> getReceiveBufferSize();

    public Optional<Integer> getConnectQueueSize();

    public Optional<Integer> getWriteSpinCount();

    public boolean isHasBaseDir();

    public int getMaxChunkSize();

    public int getMaxInitialLineLength();

    public int getMaxHeaderSize();

    public Duration getIdleTimeout();

    public FileSystemBinding getBaseDir() throws NoBaseDirException;
}

