/*
 * Decompiled with CFR 0.152.
 */
package ratpack.sse.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import java.util.List;
import ratpack.sse.ServerSentEvent;
import ratpack.sse.internal.DefaultServerSentEvent;

public class ServerSentEventEncoder {
    public static final ServerSentEventEncoder INSTANCE = new ServerSentEventEncoder();
    private static final ByteBuf EVENT_PREFIX = ServerSentEventEncoder.constant("event: ".getBytes(CharsetUtil.UTF_8));
    private static final ByteBuf DATA_PREFIX = ServerSentEventEncoder.constant("data: ".getBytes(CharsetUtil.UTF_8));
    private static final ByteBuf ID_PREFIX = ServerSentEventEncoder.constant("id: ".getBytes(CharsetUtil.UTF_8));
    private static final ByteBuf COMMENT_PREFIX = ServerSentEventEncoder.constant(": ".getBytes(CharsetUtil.UTF_8));
    private static final ByteBuf NEWLINE = DefaultServerSentEvent.NEWLINE_BYTE_BUF;

    public ByteBuf encode(ServerSentEvent event) throws Exception {
        return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{ServerSentEventEncoder.component(COMMENT_PREFIX, event.getComment()), ServerSentEventEncoder.component(ID_PREFIX, event.getId()), ServerSentEventEncoder.component(EVENT_PREFIX, event.getEvent()), ServerSentEventEncoder.component(DATA_PREFIX, event.getData()), NEWLINE});
    }

    private static ByteBuf component(ByteBuf linePrefix, List<ByteBuf> lines) {
        if (lines.isEmpty()) {
            return Unpooled.EMPTY_BUFFER;
        }
        int size = lines.size();
        if (size == 1) {
            return ServerSentEventEncoder.component(linePrefix, lines.get(0));
        }
        ByteBuf[] parts = new ByteBuf[size * 3];
        for (int i = 0; i < size; ++i) {
            int j = i * 3;
            parts[j] = linePrefix.slice();
            parts[++j] = lines.get(i);
            parts[++j] = NEWLINE.slice();
        }
        return Unpooled.wrappedBuffer((ByteBuf[])parts);
    }

    private static ByteBuf component(ByteBuf prefix, ByteBuf byteBuf) {
        if (byteBuf.readableBytes() == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{prefix.slice(), byteBuf, NEWLINE.slice()});
    }

    private static ByteBuf constant(byte[] bytes) {
        return Unpooled.unreleasableBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])bytes).asReadOnly());
    }
}

