/*
 * Decompiled with CFR 0.152.
 */
package ratpack.sse.client.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import org.reactivestreams.Publisher;
import ratpack.func.Action;
import ratpack.http.Headers;
import ratpack.http.MutableHeaders;
import ratpack.http.Response;
import ratpack.http.Status;
import ratpack.http.client.StreamedResponse;
import ratpack.sse.ServerSentEvent;
import ratpack.sse.client.ServerSentEventResponse;
import ratpack.sse.internal.ServerSentEventDecodingPublisher;
import ratpack.stream.Streams;
import ratpack.stream.TransformablePublisher;

public class DefaultServerSentEventResponse
implements ServerSentEventResponse {
    private final StreamedResponse delegate;
    private final ByteBufAllocator allocator;

    public DefaultServerSentEventResponse(StreamedResponse delegate, ByteBufAllocator allocator) {
        this.delegate = delegate;
        this.allocator = allocator;
    }

    @Override
    public boolean isEventStream() {
        if (this.getStatus().equals(Status.NO_CONTENT)) {
            return true;
        }
        String contentType = this.getHeaders().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        return contentType != null && contentType.startsWith(HttpHeaderValues.TEXT_EVENT_STREAM.toString());
    }

    @Override
    public TransformablePublisher<ServerSentEvent> getEvents() {
        if (!this.isEventStream()) {
            throw new IllegalStateException("Response is not an event stream; has content type '" + this.getHeaders().get((CharSequence)HttpHeaderNames.CONTENT_TYPE) + "' and status " + this.getStatus());
        }
        if (this.getStatus().equals(Status.NO_CONTENT)) {
            return Streams.empty();
        }
        return new ServerSentEventDecodingPublisher((Publisher<? extends ByteBuf>)this.getBody(), this.allocator).map(e -> e.touch("emit downstream"));
    }

    @Override
    public Status getStatus() {
        return this.delegate.getStatus();
    }

    @Override
    public int getStatusCode() {
        return this.delegate.getStatusCode();
    }

    @Override
    public Headers getHeaders() {
        return this.delegate.getHeaders();
    }

    @Override
    public TransformablePublisher<ByteBuf> getBody() {
        return this.delegate.getBody();
    }

    @Override
    public void forwardTo(Response response) {
        this.delegate.forwardTo(response);
    }

    @Override
    public void forwardTo(Response response, Action<? super MutableHeaders> headerMutator) {
        this.delegate.forwardTo(response, headerMutator);
    }
}

