/*
 * Decompiled with CFR 0.152.
 */
package ratpack.sse.internal;

import com.google.common.base.Strings;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import org.reactivestreams.Publisher;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.sse.Event;
import ratpack.sse.ServerSentEvent;
import ratpack.stream.Streams;
import ratpack.stream.TransformablePublisher;

public class DefaultEvent<T>
implements Event<T> {
    private final T item;
    private String id;
    private String event;
    private String data;
    private String comment;

    public DefaultEvent(T item) {
        this.item = item;
    }

    public static <T> TransformablePublisher<ServerSentEvent> toEvents(Publisher<? extends T> publisher, Action<? super Event<T>> action) {
        return Streams.map(publisher, item -> {
            Event event = (Event)action.with(new DefaultEvent<Object>(item));
            if (event.getData() == null && event.getId() == null && event.getEvent() == null && event.getComment() == null) {
                throw new IllegalArgumentException("You must supply at least one of data, event, id or comment");
            }
            return ServerSentEvent.builder().id(event.getId() == null ? Unpooled.EMPTY_BUFFER : Unpooled.wrappedBuffer((byte[])event.getId().getBytes(StandardCharsets.UTF_8))).event(event.getEvent() == null ? Unpooled.EMPTY_BUFFER : Unpooled.wrappedBuffer((byte[])event.getEvent().getBytes(StandardCharsets.UTF_8))).comment(event.getComment() == null ? Unpooled.EMPTY_BUFFER : Unpooled.wrappedBuffer((byte[])event.getComment().getBytes(StandardCharsets.UTF_8))).data(event.getData() == null ? Unpooled.EMPTY_BUFFER : Unpooled.wrappedBuffer((byte[])event.getData().getBytes(StandardCharsets.UTF_8))).build();
        });
    }

    public static <T> Event<T> fromServerSentEvent(ServerSentEvent e) {
        try {
            Event<Object> event = new DefaultEvent<Object>(null).id(Strings.emptyToNull((String)e.getIdAsString())).event(Strings.emptyToNull((String)e.getEventAsString())).data(Strings.emptyToNull((String)e.getDataAsString())).comment(Strings.emptyToNull((String)e.getCommentAsString()));
            return event;
        }
        finally {
            e.release();
        }
    }

    @Override
    public T getItem() {
        return this.item;
    }

    @Override
    public Event<T> id(Function<? super T, String> id) throws Exception {
        this.id((String)id.apply(this.item));
        return this;
    }

    @Override
    public Event<T> id(String id) {
        if (id.contains("\n")) {
            throw new IllegalArgumentException("id must not contain \\n - '" + id + "'");
        }
        this.id = id;
        return this;
    }

    @Override
    public Event<T> event(Function<? super T, String> id) throws Exception {
        this.event((String)id.apply(this.item));
        return this;
    }

    @Override
    public Event<T> event(String event) {
        if (event.contains("\n")) {
            throw new IllegalArgumentException("event must not contain \\n - '" + event + "'");
        }
        this.event = event;
        return this;
    }

    @Override
    public Event<T> data(Function<? super T, String> id) throws Exception {
        this.data((String)id.apply(this.item));
        return this;
    }

    @Override
    public Event<T> data(String data) {
        this.data = data;
        return this;
    }

    @Override
    public Event<T> comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getEvent() {
        return this.event;
    }

    @Override
    public String getData() {
        return this.data;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public String toString() {
        return "Event{id='" + this.id + '\'' + ", event='" + this.event + '\'' + ", data='" + this.data + '\'' + '}';
    }
}

