/*
 * Decompiled with CFR 0.152.
 */
package ratpack.impose;

import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import io.netty.util.concurrent.FastThreadLocal;
import java.util.Deque;
import java.util.HashMap;
import java.util.Optional;
import ratpack.func.Action;
import ratpack.func.Factory;
import ratpack.impose.Imposition;
import ratpack.impose.ImpositionsSpec;
import ratpack.registry.Registry;
import ratpack.registry.RegistrySpec;
import ratpack.util.Exceptions;

public final class Impositions {
    private static final FastThreadLocal<Deque<Impositions>> IMPOSITIONS = new FastThreadLocal();
    private final Registry registry;

    private Impositions(Registry registry) {
        this.registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T impose(Impositions impositions, Factory<? extends T> during) throws Exception {
        Deque queue = (Deque)IMPOSITIONS.get();
        if (queue == null) {
            queue = Queues.newArrayDeque();
            IMPOSITIONS.set((Object)queue);
        }
        queue.addFirst(impositions);
        try {
            Object object = during.create();
            return (T)object;
        }
        finally {
            queue.removeFirst();
            if (queue.isEmpty()) {
                IMPOSITIONS.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T imposeOver(Impositions impositions, Factory<? extends T> during) throws Exception {
        Deque queue = (Deque)IMPOSITIONS.get();
        try {
            IMPOSITIONS.set((Object)Queues.newArrayDeque());
            T t = Impositions.impose(impositions, during);
            return t;
        }
        finally {
            IMPOSITIONS.set((Object)queue);
        }
    }

    public <T> T impose(Factory<? extends T> during) throws Exception {
        return Impositions.impose(this, during);
    }

    public <T> T imposeOver(Factory<? extends T> during) throws Exception {
        return Impositions.imposeOver(this, during);
    }

    public static Impositions current() {
        return Optional.ofNullable((Deque)IMPOSITIONS.get()).flatMap(impositions -> {
            if (impositions.size() == 1) {
                return Optional.of((Impositions)impositions.getFirst());
            }
            return impositions.stream().map(imposition -> imposition.registry).reduce(Registry::join).map(Impositions::new);
        }).orElseGet(Impositions::none);
    }

    public static Impositions none() {
        return (Impositions)Exceptions.uncheck(() -> Impositions.of((Action<? super ImpositionsSpec>)Action.noop()));
    }

    public static Impositions of(Action<? super ImpositionsSpec> consumer) throws Exception {
        final HashMap map = Maps.newHashMap();
        consumer.execute((Object)new ImpositionsSpec(){

            @Override
            public ImpositionsSpec add(Imposition imposition) {
                map.put(imposition.getClass(), imposition);
                return this;
            }
        });
        return new Impositions(Registry.of(r -> map.values().forEach(arg_0 -> ((RegistrySpec)r).add(arg_0))));
    }

    @Deprecated
    public <T extends Imposition> Optional<T> get(Class<T> type) {
        return this.registry.maybeGet(type);
    }

    public <T extends Imposition> Iterable<? extends T> getAll(Class<T> type) {
        return this.registry.getAll(type);
    }
}

