/*
 * Decompiled with CFR 0.152.
 */
package ratpack.sse.internal;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.ByteProcessor;
import io.netty.util.ReferenceCounted;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ratpack.func.Action;
import ratpack.sse.ServerSentEvent;

public class ServerSentEventDecoder
implements AutoCloseable {
    private static final char[] EVENT_ID_FIELD_NAME = "event".toCharArray();
    private static final char[] DATA_FIELD_NAME = "data".toCharArray();
    private static final char[] ID_FIELD_NAME = "id".toCharArray();
    private static final byte COLON_BYTE = 58;
    private static final byte NEWLINE_BYTE = 10;
    private static final byte SPACE_BYTE = 32;
    private static final ByteProcessor IS_NEWLINE_OR_SPACE = value -> value == 10 || value == 32;
    private static final ByteProcessor IS_COLON_OR_SPACE = value -> value == 58 || value == 32;
    private List<ByteBuf> idBuffer = new ArrayList<ByteBuf>(1);
    private List<ByteBuf> eventBuffer = new ArrayList<ByteBuf>(1);
    private List<ByteBuf> dataBuffer = new ArrayList<ByteBuf>(1);
    private ByteBuf buffer;
    private Type currentFieldType;
    private State state = State.ReadFieldName;
    private final ByteBufAllocator allocator;
    private final Action<? super ServerSentEvent> emitter;

    public ServerSentEventDecoder(ByteBufAllocator allocator, Action<? super ServerSentEvent> emitter) {
        this.allocator = allocator;
        this.emitter = emitter;
    }

    public void decode(ByteBuf in) throws Exception {
        if (this.state == State.Closed) {
            in.release();
            return;
        }
        try {
            this.doDecode(in);
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
        finally {
            in.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDecode(ByteBuf in) throws Exception {
        block14: while (in.isReadable()) {
            int readerIndexAtStart = in.readerIndex();
            switch (this.state) {
                case SkipColonAndWhiteSpaces: {
                    if (!ServerSentEventDecoder.skipColonAndWhiteSpaces(in)) break;
                    this.state = State.ReadFieldValue;
                    break;
                }
                case DiscardUntilEOL: {
                    if (!ServerSentEventDecoder.skipTillEOL(in)) break;
                    this.state = State.DiscardEOL;
                    break;
                }
                case DiscardEOL: {
                    byte b = in.readByte();
                    assert (b == 10);
                    this.state = State.ReadFieldName;
                    break;
                }
                case ReadFieldName: {
                    ByteBuf fieldNameBuffer;
                    byte peek = ServerSentEventDecoder.peek(in);
                    if (peek == 10) {
                        in.readByte();
                        this.emit();
                        break;
                    }
                    int endOfNameIndex = ServerSentEventDecoder.findColon(in);
                    if (endOfNameIndex == -1) {
                        endOfNameIndex = ServerSentEventDecoder.findNewline(in);
                    }
                    if (endOfNameIndex == -1) {
                        if (this.buffer == null) {
                            this.buffer = this.allocator.buffer();
                        }
                        this.buffer.writeBytes(in);
                        break;
                    }
                    int fieldNameLengthInTheCurrentBuffer = endOfNameIndex - readerIndexAtStart;
                    if (this.buffer == null) {
                        fieldNameBuffer = in.retainedSlice(in.readerIndex(), fieldNameLengthInTheCurrentBuffer);
                        in.skipBytes(fieldNameLengthInTheCurrentBuffer);
                    } else {
                        in.readBytes(this.buffer, fieldNameLengthInTheCurrentBuffer);
                        fieldNameBuffer = this.buffer;
                        this.buffer = null;
                    }
                    this.state = State.SkipColonAndWhiteSpaces;
                    try {
                        this.currentFieldType = ServerSentEventDecoder.readCurrentFieldTypeFromBuffer(fieldNameBuffer);
                        continue block14;
                    }
                    finally {
                        if (this.currentFieldType == null) {
                            this.state = State.DiscardUntilEOL;
                        }
                        fieldNameBuffer.release();
                        continue block14;
                    }
                }
                case ReadFieldValue: {
                    List<ByteBuf> field;
                    int endOfLineStartIndex = ServerSentEventDecoder.findNewline(in);
                    if (endOfLineStartIndex == -1) {
                        if (this.buffer == null) {
                            this.buffer = this.allocator.buffer(in.readableBytes());
                        }
                        this.buffer.writeBytes(in);
                        break;
                    }
                    int bytesAvailableInThisIteration = endOfLineStartIndex - readerIndexAtStart;
                    if (this.buffer == null) {
                        this.buffer = this.allocator.buffer(bytesAvailableInThisIteration, bytesAvailableInThisIteration);
                    }
                    this.buffer.writeBytes(in, bytesAvailableInThisIteration);
                    switch (this.currentFieldType) {
                        case Data: {
                            field = this.dataBuffer;
                            break;
                        }
                        case Id: {
                            field = this.idBuffer;
                            break;
                        }
                        default: {
                            field = this.eventBuffer;
                        }
                    }
                    field.add(this.buffer);
                    this.buffer = null;
                    this.state = State.DiscardUntilEOL;
                }
            }
        }
    }

    private void emit() throws Exception {
        ServerSentEvent event = ServerSentEvent.builder().id(ServerSentEventDecoder.single(this.idBuffer)).event(ServerSentEventDecoder.single(this.eventBuffer)).unsafeDataLines(ServerSentEventDecoder.multi(this.dataBuffer)).build();
        if (!event.getData().isEmpty() || event.getEvent().isReadable() || event.getId().isReadable()) {
            this.emitter.execute((Object)event.touch("emitting"));
        } else {
            event.release();
        }
        this.state = State.ReadFieldName;
    }

    private static List<ByteBuf> multi(List<ByteBuf> buffers) {
        try {
            if (buffers.isEmpty()) {
                List<ByteBuf> list = Collections.emptyList();
                return list;
            }
            if (buffers.size() == 1) {
                ImmutableList immutableList = ImmutableList.of((Object)buffers.get(0));
                return immutableList;
            }
            ImmutableList immutableList = ImmutableList.copyOf(buffers);
            return immutableList;
        }
        finally {
            buffers.clear();
        }
    }

    private static ByteBuf single(List<ByteBuf> bufs) {
        try {
            if (bufs.isEmpty()) {
                ByteBuf byteBuf = Unpooled.EMPTY_BUFFER;
                return byteBuf;
            }
            if (bufs.size() == 1) {
                ByteBuf byteBuf = bufs.get(0);
                return byteBuf;
            }
            throw new IllegalStateException("expected single line but got multi");
        }
        finally {
            bufs.clear();
        }
    }

    private static Type readCurrentFieldTypeFromBuffer(ByteBuf fieldNameBuffer) {
        Type toReturn = Type.Data;
        ServerSentEventDecoder.skipSpaceAndNewlines(fieldNameBuffer);
        int readableBytes = fieldNameBuffer.readableBytes();
        int readerIndexAtStart = fieldNameBuffer.readerIndex();
        char[] fieldNameToVerify = DATA_FIELD_NAME;
        boolean verified = false;
        int actualFieldNameIndexToCheck = 0;
        block5: for (int i = readerIndexAtStart; i < readerIndexAtStart + readableBytes; ++i) {
            char charAtI = (char)fieldNameBuffer.getByte(i);
            if (i == readerIndexAtStart) {
                switch (charAtI) {
                    case 'e': {
                        fieldNameToVerify = EVENT_ID_FIELD_NAME;
                        toReturn = Type.EventType;
                        continue block5;
                    }
                    case 'd': {
                        fieldNameToVerify = DATA_FIELD_NAME;
                        toReturn = Type.Data;
                        continue block5;
                    }
                    case 'i': {
                        fieldNameToVerify = ID_FIELD_NAME;
                        toReturn = Type.Id;
                        continue block5;
                    }
                    default: {
                        return null;
                    }
                }
            }
            if (++actualFieldNameIndexToCheck >= fieldNameToVerify.length || charAtI != fieldNameToVerify[actualFieldNameIndexToCheck]) {
                verified = false;
                break;
            }
            verified = true;
        }
        if (verified) {
            return toReturn;
        }
        return null;
    }

    @Override
    public void close() {
        if (this.idBuffer != null) {
            this.idBuffer.forEach(ReferenceCounted::release);
            this.idBuffer = null;
        }
        if (this.eventBuffer != null) {
            this.eventBuffer.forEach(ReferenceCounted::release);
            this.eventBuffer = null;
        }
        if (this.dataBuffer != null) {
            this.dataBuffer.forEach(ReferenceCounted::release);
            this.dataBuffer = null;
        }
        if (this.buffer != null) {
            this.buffer.release();
            this.buffer = null;
        }
        this.state = State.Closed;
    }

    private static int findColon(ByteBuf byteBuf) {
        return ServerSentEventDecoder.find(byteBuf, (byte)58);
    }

    private static int findNewline(ByteBuf byteBuf) {
        return ServerSentEventDecoder.find(byteBuf, (byte)10);
    }

    private static void skipSpaceAndNewlines(ByteBuf byteBuf) {
        ServerSentEventDecoder.skipWhile(byteBuf, IS_NEWLINE_OR_SPACE);
    }

    private static boolean skipColonAndWhiteSpaces(ByteBuf byteBuf) {
        return ServerSentEventDecoder.skipWhile(byteBuf, IS_COLON_OR_SPACE);
    }

    private static boolean skipTillEOL(ByteBuf in) {
        return ServerSentEventDecoder.skipUntil(in, (byte)10);
    }

    private static boolean skipWhile(ByteBuf byteBuf, ByteProcessor processor) {
        int lastIndexProcessed = byteBuf.forEachByte(processor);
        if (lastIndexProcessed == -1) {
            byteBuf.readerIndex(byteBuf.writerIndex());
        } else {
            byteBuf.readerIndex(lastIndexProcessed);
        }
        return lastIndexProcessed != -1;
    }

    private static boolean skipUntil(ByteBuf byteBuf, byte target) {
        int indexOf = ServerSentEventDecoder.find(byteBuf, target);
        if (indexOf == -1) {
            byteBuf.readerIndex(byteBuf.writerIndex());
            return false;
        }
        byteBuf.readerIndex(indexOf);
        return true;
    }

    private static int find(ByteBuf byteBuf, byte target) {
        return byteBuf.indexOf(byteBuf.readerIndex(), byteBuf.writerIndex(), target);
    }

    private static byte peek(ByteBuf buffer) {
        return buffer.getByte(buffer.readerIndex());
    }

    private static enum Type {
        Data,
        Id,
        EventType;

    }

    private static enum State {
        ReadFieldName,
        SkipColonAndWhiteSpaces,
        ReadFieldValue,
        DiscardUntilEOL,
        DiscardEOL,
        Closed;

    }
}

