/*
 * Decompiled with CFR 0.152.
 */
package ratpack.sse.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.internal.ObjectPool;
import java.nio.charset.StandardCharsets;
import java.util.List;
import ratpack.bytebuf.ByteBufRef;
import ratpack.sse.ServerSentEvent;
import ratpack.sse.internal.DefaultServerSentEvent;

public class ServerSentEventEncoder {
    public static final ServerSentEventEncoder INSTANCE = new ServerSentEventEncoder();
    private static final ObjectPool<ByteBuf> EVENT_PREFIX_POOL = ServerSentEventEncoder.pooledConstant("event: ");
    private static final ObjectPool<ByteBuf> DATA_PREFIX_POOL = ServerSentEventEncoder.pooledConstant("data: ");
    private static final ObjectPool<ByteBuf> ID_PREFIX_POOL = ServerSentEventEncoder.pooledConstant("id: ");
    private static final ObjectPool<ByteBuf> COMMENT_PREFIX_POOL = ServerSentEventEncoder.pooledConstant(": ");
    private static final ByteBuf NEWLINE = DefaultServerSentEvent.NEWLINE_BYTE_BUF;
    private static final ObjectPool<ByteBuf> NEWLINE_POOL = ServerSentEventEncoder.pooledConstant(NEWLINE);

    public ByteBuf encode(ServerSentEvent sse) throws Exception {
        int j;
        List<ByteBuf> comment = sse.getComment();
        ByteBuf id = sse.getId();
        ByteBuf event = sse.getEvent();
        List<ByteBuf> data = sse.getData();
        int count = 0;
        if (!comment.isEmpty()) {
            count += comment.size() * 3;
        }
        if (id.isReadable()) {
            count += 3;
        }
        if (event.isReadable()) {
            count += 3;
        }
        if (!data.isEmpty()) {
            count += data.size() * 3;
        }
        if (count == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBuf[] bufs = new ByteBuf[count + 1];
        int i = 0;
        for (j = 0; j < comment.size(); ++j) {
            bufs[i++] = (ByteBuf)COMMENT_PREFIX_POOL.get();
            bufs[i++] = comment.get(j);
            bufs[i++] = (ByteBuf)NEWLINE_POOL.get();
        }
        if (id.isReadable()) {
            bufs[i++] = (ByteBuf)ID_PREFIX_POOL.get();
            bufs[i++] = id;
            bufs[i++] = (ByteBuf)NEWLINE_POOL.get();
        } else {
            id.release();
        }
        if (event.isReadable()) {
            bufs[i++] = (ByteBuf)EVENT_PREFIX_POOL.get();
            bufs[i++] = event;
            bufs[i++] = (ByteBuf)NEWLINE_POOL.get();
        } else {
            event.release();
        }
        for (j = 0; j < data.size(); ++j) {
            bufs[i++] = (ByteBuf)DATA_PREFIX_POOL.get();
            bufs[i++] = data.get(j);
            bufs[i++] = (ByteBuf)NEWLINE_POOL.get();
        }
        bufs[i] = (ByteBuf)NEWLINE_POOL.get();
        return Unpooled.wrappedUnmodifiableBuffer((ByteBuf[])bufs);
    }

    private static ObjectPool<ByteBuf> pooledConstant(String string) {
        return ServerSentEventEncoder.pooledConstant(string.getBytes(StandardCharsets.UTF_8));
    }

    private static ObjectPool<ByteBuf> pooledConstant(byte[] bytes) {
        return ServerSentEventEncoder.pooledConstant(Unpooled.wrappedBuffer((byte[])bytes));
    }

    private static ObjectPool<ByteBuf> pooledConstant(final ByteBuf byteBuf) {
        return ObjectPool.newPool((ObjectPool.ObjectCreator)new ObjectPool.ObjectCreator<ByteBuf>(){

            public ByteBuf newObject(final ObjectPool.Handle<ByteBuf> handle) {
                return new ByteBufRef(byteBuf.asReadOnly()){

                    @Override
                    protected void deallocate() {
                        this.delegate.resetReaderIndex();
                        this.counted.reset();
                        handle.recycle((Object)this);
                    }
                };
            }
        });
    }
}

