/*
 * Decompiled with CFR 0.152.
 */
package ratpack.sse;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import ratpack.sse.ServerSentEventBuilder;
import ratpack.sse.internal.DefaultServerSentEvent;

public interface ServerSentEvent
extends AutoCloseable {
    public static ServerSentEventBuilder builder() {
        return new DefaultServerSentEvent();
    }

    public ByteBuf getId();

    default public String getIdAsString() {
        return DefaultServerSentEvent.asString(this.getId());
    }

    public ByteBuf getEvent();

    default public String getEventAsString() {
        return DefaultServerSentEvent.asString(this.getEvent());
    }

    public List<ByteBuf> getData();

    default public String getDataAsString() {
        return DefaultServerSentEvent.asMultilineString(this.getData());
    }

    public List<ByteBuf> getComment();

    default public String getCommentAsString() {
        return DefaultServerSentEvent.asMultilineString(this.getComment());
    }

    public static ByteBuf join(List<ByteBuf> lines) {
        if (lines.isEmpty()) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (lines.size() == 1) {
            return lines.get(0).retainedSlice();
        }
        int components = lines.size() * 2 - 1;
        ByteBuf[] byteBufs = new ByteBuf[components];
        byteBufs[0] = lines.get(0).slice();
        for (int i = 1; i < lines.size(); ++i) {
            byteBufs[i * 2 - 1] = DefaultServerSentEvent.NEWLINE_BYTE_BUF.slice();
            byteBufs[i * 2] = lines.get(i).slice();
        }
        return Unpooled.wrappedUnmodifiableBuffer((ByteBuf[])byteBufs);
    }

    @Override
    public void close();
}

