/*
 * Decompiled with CFR 0.152.
 */
package ratpack.sse.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ratpack.sse.ServerSentEvent;
import ratpack.sse.ServerSentEventBuilder;

public class DefaultServerSentEvent
implements ServerSentEvent,
ServerSentEventBuilder {
    private static final byte NEWLINE_BYTE = 10;
    public static final ByteBuf NEWLINE_BYTE_BUF = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{10}).asReadOnly());
    private ByteBuf id = Unpooled.EMPTY_BUFFER;
    private ByteBuf event = Unpooled.EMPTY_BUFFER;
    private List<ByteBuf> data = Collections.emptyList();
    private List<ByteBuf> comment = Collections.emptyList();

    @Override
    public ByteBuf getId() {
        return this.id;
    }

    @Override
    public ByteBuf getEvent() {
        return this.event;
    }

    @Override
    public List<ByteBuf> getData() {
        return this.data;
    }

    @Override
    public List<ByteBuf> getComment() {
        return this.comment;
    }

    @Override
    public ServerSentEventBuilder id(ByteBuf id) {
        if (DefaultServerSentEvent.containsNewline(id)) {
            throw new IllegalArgumentException("id must not contain \\n - '" + id + "'");
        }
        ReferenceCountUtil.release((Object)this.id);
        this.id = id;
        return this;
    }

    @Override
    public ServerSentEventBuilder event(ByteBuf event) {
        if (DefaultServerSentEvent.containsNewline(event)) {
            throw new IllegalArgumentException("event must not contain \\n - '" + event + "'");
        }
        ReferenceCountUtil.release((Object)this.event);
        this.event = event;
        return this;
    }

    @Override
    public ServerSentEventBuilder data(ByteBuf data) {
        return this.unsafeDataLines(DefaultServerSentEvent.toLines(data));
    }

    @Override
    public ServerSentEventBuilder unsafeDataLines(List<ByteBuf> data) {
        this.data.forEach(ReferenceCountUtil::release);
        this.data = data;
        return this;
    }

    @Override
    public ServerSentEventBuilder comment(ByteBuf comment) {
        return this.unsafeCommentLines(DefaultServerSentEvent.toLines(comment));
    }

    @Override
    public ServerSentEventBuilder unsafeCommentLines(List<ByteBuf> comment) {
        this.comment.forEach(ReferenceCountUtil::release);
        this.comment = comment;
        return this;
    }

    @Override
    public ServerSentEvent build() {
        return this;
    }

    private static boolean containsNewline(ByteBuf byteBuf) {
        return ByteBufUtil.indexOf((ByteBuf)byteBuf, (int)0, (int)byteBuf.readableBytes(), (byte)10) != -1;
    }

    public static String asString(ByteBuf byteBuf) {
        return byteBuf.toString(StandardCharsets.UTF_8);
    }

    public static String asMultilineString(List<ByteBuf> lines) {
        ByteBuf joined = ServerSentEvent.join(lines);
        String string = joined.toString(StandardCharsets.UTF_8);
        joined.release();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ByteBuf> toLines(ByteBuf text) {
        try {
            int length = text.readableBytes();
            if (length == 0) {
                List<ByteBuf> list = Collections.emptyList();
                return list;
            }
            int newlineIndex = ByteBufUtil.indexOf((ByteBuf)text, (int)0, (int)length, (byte)10);
            if (newlineIndex == -1) {
                List<ByteBuf> list = Collections.singletonList(text.retainedSlice());
                return list;
            }
            ArrayList<ByteBuf> lines = new ArrayList<ByteBuf>();
            lines.add(text.retainedSlice(0, newlineIndex));
            int cursor = newlineIndex + 1;
            while (cursor <= length) {
                newlineIndex = ByteBufUtil.indexOf((ByteBuf)text, (int)cursor, (int)length, (byte)10);
                if (newlineIndex == -1) {
                    newlineIndex = length;
                }
                lines.add(text.retainedSlice(cursor, newlineIndex - cursor));
                cursor = newlineIndex + 1;
            }
            ArrayList<ByteBuf> arrayList = lines;
            return arrayList;
        }
        finally {
            text.release();
        }
    }

    @Override
    public void close() {
        ReferenceCountUtil.safeRelease((Object)this.id);
        ReferenceCountUtil.safeRelease((Object)this.event);
        this.data.forEach(ReferenceCountUtil::safeRelease);
        this.comment.forEach(ReferenceCountUtil::safeRelease);
    }
}

